/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhocworkflows.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhocworkflows.rest.permissions.EditPagePermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.ViewPagePermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.ViewWorkflowPermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowVisibilityPermissionsRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsLiteAppRequired;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowCustomMessageException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflow.rest.model.Message;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.workflow.WorkflowException;
import java.lang.reflect.Method;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestResources {
    private static final Logger log = LoggerFactory.getLogger(AbstractRestResources.class);
    protected final PageManager pageManager;
    protected final PermissionManager permissionManager;
    protected final WorkflowPermissionManager workflowPermissionManager;
    protected final SpaceManager spaceManager;
    protected final SpacePermissionManager spacePermissionManager;
    protected final AccessModeService accessModeService;
    protected final WorkflowsFeatureManager workflowsFeatureManager;
    protected final WorkflowConfigurationManager workflowConfigurationManager;
    protected final ComalaI18nBean comalaI18nBean;
    private static final String APPLICATION_PERMISSION_ERROR = "The application has no permission over ";

    public AbstractRestResources(PageManager pageManager, PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, AccessModeService accessModeService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, ComalaI18nBean comalaI18nBean) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.workflowPermissionManager = workflowPermissionManager;
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
        this.accessModeService = accessModeService;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    private void validatePermission(WorkflowCommand command, AbstractPage page) throws ApplicationPermissionException {
        Method enclosingMethod = command.getClass().getEnclosingMethod();
        if (enclosingMethod == null) {
            throw new RuntimeException("command must be anynomous class");
        }
        boolean allowed = true;
        boolean skip = false;
        if (null != enclosingMethod.getAnnotation(WorkflowsAppRequired.class) || null != command.getClass().getEnclosingClass().getAnnotation(WorkflowsAppRequired.class)) {
            skip = allowed = this.workflowsFeatureManager.isWorkflowsApp();
        }
        if (!(skip || null == enclosingMethod.getAnnotation(WorkflowsLiteAppRequired.class) && null == command.getClass().getEnclosingClass().getAnnotation(WorkflowsLiteAppRequired.class))) {
            allowed = this.workflowsFeatureManager.isWorkflowsLiteApp();
        }
        if (!allowed) {
            throw new ApplicationPermissionException(APPLICATION_PERMISSION_ERROR + command.getClass().getName() + ":" + command.getClass().getEnclosingMethod().getName());
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!(this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)page) || null == enclosingMethod.getAnnotation(ViewPagePermissionRequired.class) && null == enclosingMethod.getAnnotation(EditPagePermissionRequired.class) && null == enclosingMethod.getAnnotation(ViewWorkflowPermissionRequired.class))) {
            throw new ApplicationPermissionException("The user has no view permission on the page");
        }
        if (null != enclosingMethod.getAnnotation(EditPagePermissionRequired.class) && !this.canEdit(user, page)) {
            throw new ApplicationPermissionException("Forbidden: The user has no edit permission on the page");
        }
        if (null != enclosingMethod.getAnnotation(WorkflowVisibilityPermissionsRequired.class) && !this.hasEditPermissionOverrideSettingEnabled(page.getSpaceKey()) && !this.canEdit(user, page)) {
            throw new ApplicationPermissionException("Forbidden: The user has no edit permission on the page and the Workflows visibility configuration setting does not allow to override that restriction.");
        }
        if (null != enclosingMethod.getAnnotation(ViewWorkflowPermissionRequired.class) && !this.workflowPermissionManager.canViewDrafts(page, user)) {
            throw new ApplicationPermissionException("Forbidden: The user has no permission to view workflows on the page");
        }
    }

    private boolean hasEditPermissionOverrideSettingEnabled(String spaceKey) {
        return WorkflowVisibilityInternal.ANY.equals((Object)this.workflowConfigurationManager.getHistoryVisibility(spaceKey));
    }

    protected boolean canEdit(ConfluenceUser user, AbstractPage page) {
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption(() -> this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)page));
    }

    protected boolean canEditAndCreate(Space space) {
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption(() -> this.spacePermissionManager.hasPermission("EDITSPACE", space, (User)AuthenticatedUserThreadLocal.get()));
    }

    protected abstract Response getStatus(AbstractPage var1, Message var2);

    public abstract class WorkflowCommand {
        protected abstract Response doInCommand(AbstractPage var1) throws WorkflowException;

        public Response execute(long pageId) {
            ContentEntityObject object = AbstractRestResources.this.pageManager.getById(pageId);
            AbstractPage page = null;
            if (object instanceof AbstractPage) {
                page = (AbstractPage)object;
            }
            if (page == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Cant find page " + pageId);
                }
                return Response.noContent().build();
            }
            try {
                AbstractRestResources.this.validatePermission(this, page);
                return this.doInCommand(page);
            }
            catch (ApplicationPermissionException e) {
                if (e.getMessage().contains("Forbidden")) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
            }
            catch (WorkflowException e) {
                Message message;
                if (e instanceof WorkflowCustomMessageException) {
                    message = ((WorkflowCustomMessageException)e).getCustomMessage();
                } else if (e instanceof WorkflowUserException) {
                    message = new Message(Message.MessageType.ERROR.toString(), "Error", e.getMessage(), true);
                } else {
                    message = new Message(Message.MessageType.ERROR.toString(), "Error", AbstractRestResources.this.comalaI18nBean.getText("approvalsworkflow.workflow.error", new String[]{e.getMessage()}), true);
                    log.error("", (Throwable)e);
                }
                return AbstractRestResources.this.getStatus(page, message);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                return Response.serverError().build();
            }
        }
    }
}

