/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers;

import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateSelection;
import com.comalatech.confluence.states.model.StateSubmission;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.restv2.model.RestState;
import com.comalatech.confluence.workflow.restv2.model.RestTransitions;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class StateMapper
implements Mapper<State, RestState> {
    @Override
    public RestState toRest(State state) {
        RestState restState = new RestState();
        restState.name = state.getName();
        restState.description = state.getDescription();
        restState.transitions = this.toRestTransitions(state);
        restState.finalState = state.isFinalState() ? Boolean.valueOf(true) : null;
        restState.assignable = state.isAssignable() ? Boolean.valueOf(true) : null;
        restState.taskable = state.isTaskable() ? Boolean.valueOf(true) : null;
        restState.dueDate = state.getDueDate();
        restState.changeDueDate = state.isChangeDueDate() ? Boolean.valueOf(true) : null;
        restState.hideFromPath = state.isHideFromPath() ? Boolean.valueOf(true) : null;
        restState.hideSelection = state.isHideSelectionProperty() ? Boolean.valueOf(true) : null;
        restState.versionsCompleted = state.isVersionsCompleted() ? Boolean.valueOf(true) : null;
        restState.colour = state.getColour();
        List<String> list = restState.requiredParams = StringUtils.isNotEmpty((CharSequence)state.getRequiredParams()) ? Arrays.asList(StringUtils.split((String)state.getRequiredParams(), (String)",")) : null;
        if (state.getApprovals() != null && state.getApprovals().size() > 0) {
            restState.approvals = state.getApprovals().stream().map(Mappers.approvalMapper::toRest).collect(Collectors.toList());
        }
        if (state.getTasks() != null && state.getTasks().size() > 0) {
            restState.tasks = state.getTasks().stream().map(Mappers.taskMapper::toRest).collect(Collectors.toList());
        }
        if (state.getReadAck() != null) {
            restState.readAck = Mappers.readAckMapper.toRest(state.getReadAck());
        }
        return restState;
    }

    @Override
    public State fromRest(RestState restState) {
        State state = new State(restState.name, BooleanUtils.isTrue((Boolean)restState.finalState));
        state.setDescription(restState.description);
        state.setAssignable(BooleanUtils.isTrue((Boolean)restState.assignable));
        state.setTaskable(BooleanUtils.isTrue((Boolean)restState.taskable));
        state.setChangeDueDate(BooleanUtils.isTrue((Boolean)restState.changeDueDate));
        this.parseDueDateFromRest(restState.dueDate, state);
        state.setHideFromPath(BooleanUtils.isTrue((Boolean)restState.hideFromPath));
        state.setHideSelection(BooleanUtils.isTrue((Boolean)restState.hideSelection));
        state.setVersionsCompleted(BooleanUtils.isTrue((Boolean)restState.versionsCompleted));
        state.setColour(restState.colour);
        state.setRequiredParams(StringUtils.join(restState.requiredParams, (String)","));
        if (restState.transitions != null) {
            state.setApprovedStateName(restState.transitions.approved);
            state.setRejectedStateName(restState.transitions.rejected);
            state.setUpdatedStateName(restState.transitions.updated);
            state.setExpiredStateName(restState.transitions.expired);
            state.setCompletedStateName(restState.transitions.completed);
            ArrayList<StateSelection> stateSelections = new ArrayList<StateSelection>();
            if (restState.transitions.select != null) {
                String[] allowedStateNames = restState.transitions.select.toArray(new String[restState.transitions.select.size()]);
                List conditions = null;
                if (restState.transitions.selectConditions != null) {
                    conditions = restState.transitions.selectConditions.stream().map(Mappers.conditionMapper::fromRest).filter(Objects::nonNull).collect(Collectors.toList());
                }
                stateSelections.add(new StateSelection(conditions, allowedStateNames));
            }
            if (restState.transitions.submit != null) {
                stateSelections.add(new StateSubmission(null, restState.transitions.submit));
            }
            state.setStateSelections(stateSelections);
        }
        if (restState.approvals != null) {
            state.setApprovals(restState.approvals.stream().map(Mappers.approvalMapper::fromRest).collect(Collectors.toList()));
        }
        if (restState.tasks != null) {
            state.setTasks(restState.tasks.stream().map(Mappers.taskMapper::fromRest).collect(Collectors.toList()));
        }
        if (restState.readAck != null) {
            state.setReadAck(Mappers.readAckMapper.fromRest(restState.readAck));
        }
        return state;
    }

    private RestTransitions toRestTransitions(State state) {
        RestTransitions restTransitions = new RestTransitions();
        restTransitions.approved = state.getApprovedStateName();
        restTransitions.rejected = state.getRejectedStateName();
        restTransitions.updated = state.getUpdatedStateName();
        restTransitions.expired = state.getExpiredStateName();
        if (state.getSubmitState() != null) {
            restTransitions.submit = state.getSubmitState().getName();
        }
        restTransitions.completed = state.getCompletedStateName();
        if (state.getStateSelections() != null && state.getStateSelections().size() > 0) {
            ArrayList<String> select = new ArrayList<String>();
            ArrayList<Condition> selectConditions = new ArrayList<Condition>();
            for (StateSelection stateSelection : state.getStateSelections()) {
                if (!stateSelection.isExplicit()) continue;
                selectConditions.addAll(stateSelection.getConditions());
                for (State option : stateSelection.getAllowedStates()) {
                    if (option.getName().equals(restTransitions.submit)) continue;
                    select.add(option.getName());
                }
            }
            restTransitions.select = select.isEmpty() ? null : select;
            restTransitions.selectConditions = selectConditions.stream().map(Mappers.conditionMapper::toRest).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return restTransitions;
    }
}

