/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.comalatech.confluence.workflow.model.WorkflowElement;
import com.comalatech.confluence.workflowcontainer.model.Macroable;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;

public class WorkflowPageHeader
extends WorkflowElement
implements Macroable {
    public static final String VISIBILITY_PARAM = "visibility";
    private String body;
    private Visibility visibility;

    public WorkflowPageHeader() {
        super(null);
    }

    public WorkflowPageHeader(String body, String visibility) {
        super(null);
        this.body = body.trim();
        this.visibility = Visibility.parse(visibility);
    }

    public String getBody(boolean readOnly) {
        if (this.visibility == Visibility.ALL || readOnly && this.visibility == Visibility.READONLY || !readOnly && this.visibility == Visibility.CONTRIBUTORS) {
            return this.body;
        }
        return null;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    protected String getName() {
        return "pageheader";
    }

    @Override
    public SerializableMacro toMacro() {
        SerializableMacro macro = new SerializableMacro(this.getName(), true);
        macro.setBody(this.body);
        if (this.visibility != Visibility.CONTRIBUTORS) {
            macro.addParameter(VISIBILITY_PARAM, (Object)this.visibility.toString());
        }
        return macro;
    }

    public static enum Visibility {
        CONTRIBUTORS("contributors"),
        READONLY("readonly"),
        ALL("all");

        String key;

        private Visibility(String key) {
            this.key = key;
        }

        public static Visibility parse(String key) {
            for (Visibility visibility : Visibility.values()) {
                if (!visibility.key.equalsIgnoreCase(key)) continue;
                return visibility;
            }
            return CONTRIBUTORS;
        }

        public String toString() {
            return this.key;
        }
    }
}

