/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners.triggers;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostMovedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.manager.EventHistoryManager;
import com.comalatech.confluence.readack.events.ReadAckCompletedEventImpl;
import com.comalatech.confluence.states.event.StateExpireEvent;
import com.comalatech.confluence.states.event.StateExpiryUpdatedEvent;
import com.comalatech.confluence.states.event.blogpost.BlogPostStateClosedEvent;
import com.comalatech.confluence.states.event.blogpost.BlogPostStateInitEvent;
import com.comalatech.confluence.states.event.blogpost.BlogPostStateTransitionEvent;
import com.comalatech.confluence.states.event.blogpost.BlogPostStateTransitionOverrideEvent;
import com.comalatech.confluence.states.event.page.PageStateClosedEvent;
import com.comalatech.confluence.states.event.page.PageStateInitEvent;
import com.comalatech.confluence.states.event.page.PageStateTransitionEvent;
import com.comalatech.confluence.states.event.page.PageStateTransitionOverrideEvent;
import com.comalatech.confluence.tasks.event.DefaultTaskDueDateExpiredEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskAssignEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskCompleteEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskCreateEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskDeletedEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskDueDateCreatedEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskDueDateDeletedEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskDueDateUpdatedEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskUnassignEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskUpdatedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskAssignEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskCompleteEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskCreateEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskDeletedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskDueDateCreatedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskDueDateDeletedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskDueDateUpdatedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskUnassignEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskUpdatedEvent;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.events.BlogPostApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.BlogPostApprovalRejectEvent;
import com.comalatech.confluence.workflow.events.DefaultApprovalUnassignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.PageApprovalAssignedEvent;
import com.comalatech.confluence.workflow.events.PageApprovalRejectEvent;
import com.comalatech.confluence.workflow.model.Trigger;
import com.comalatech.confluence.workflow.model.TriggerEvents;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggersListener
extends WorkflowsListener {
    private static final Logger log = LoggerFactory.getLogger(TriggersListener.class);
    protected final WorkflowAccessor workflowAccessor;
    protected final WorkflowActionManager workflowActionManager;
    private final DarkFeatureManager darkFeatureManager;
    private final EventHistoryManager eventHistoryManager;
    private static final Class[] HANDLED_ACTIVITY_HISTORY_EVENTS = new Class[]{StateExpireEvent.class, StateExpiryUpdatedEvent.class, BlogPostStateTransitionOverrideEvent.class, PageStateTransitionOverrideEvent.class, BlogPostStateInitEvent.class, PageStateInitEvent.class, PageStateTransitionEvent.class, BlogPostStateTransitionEvent.class, PageStateClosedEvent.class, BlogPostStateClosedEvent.class, PageApprovalApproveEvent.class, BlogPostApprovalApproveEvent.class, PageApprovalRejectEvent.class, BlogPostApprovalRejectEvent.class, PageApprovalAssignedEvent.class, BlogPostApprovalAssignedEvent.class, DefaultApprovalUnassignedEvent.class, ReadAckCompletedEventImpl.class, PageTaskCreateEvent.class, BlogPostTaskCreateEvent.class, PageTaskCompleteEvent.class, BlogPostTaskCompleteEvent.class, PageTaskDeletedEvent.class, BlogPostTaskDeletedEvent.class, PageTaskAssignEvent.class, BlogPostTaskAssignEvent.class, PageTaskUnassignEvent.class, BlogPostTaskUnassignEvent.class, DefaultTaskDueDateExpiredEvent.class, PageTaskUpdatedEvent.class, BlogPostTaskUpdatedEvent.class, PageTaskDueDateDeletedEvent.class, BlogPostTaskDueDateDeletedEvent.class, PageTaskDueDateUpdatedEvent.class, BlogPostTaskDueDateUpdatedEvent.class, PageTaskDueDateCreatedEvent.class, BlogPostTaskDueDateCreatedEvent.class, PageRemoveEvent.class, BlogPostRemoveEvent.class, PageMoveEvent.class, BlogPostMovedEvent.class};

    public TriggersListener(WorkflowAccessor workflowAccessor, WorkflowActionManager workflowActionManager, EventHistoryManager eventHistoryManager, DarkFeatureManager darkFeatureManager, EventPublisher eventPublisher) {
        super(eventPublisher);
        this.workflowAccessor = workflowAccessor;
        this.workflowActionManager = workflowActionManager;
        this.darkFeatureManager = darkFeatureManager;
        this.eventHistoryManager = eventHistoryManager;
    }

    public void handleEventTrigger(ContentEvent event) {
        try {
            this.logEventSource((ConfluenceEvent)event);
            this.processHistoryEvent(event);
            PageWorkflows pageWorkflows = this.getPageWorkflows((ConfluenceEvent)event);
            if (pageWorkflows == null) {
                return;
            }
            this.evaluateTriggers(pageWorkflows, (ConfluenceEvent)event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }

    public void logEventSource(ConfluenceEvent event) {
        if (event.getSource() == null) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring other node source event: " + event);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Handling event: " + event);
        }
    }

    public PageWorkflows getPageWorkflows(ConfluenceEvent event) {
        try {
            return this.workflowAccessor.getWorkflows(null, event);
        }
        catch (WorkflowException e) {
            if (log.isDebugEnabled()) {
                log.error("", (Throwable)e);
            } else {
                log.error(e.getMessage());
            }
            return null;
        }
    }

    public void evaluateTriggers(PageWorkflows pageWorkflows, ConfluenceEvent event) {
        ValueStore valueStore = pageWorkflows.getValueStore();
        Iterator<Workflow> iterator = pageWorkflows.getWorkflows().iterator();
        while (iterator.hasNext()) {
            Workflow o;
            Workflow workflow = o = iterator.next();
            try {
                this.evaluateTriggers(workflow, valueStore, event);
            }
            catch (WorkflowException e) {
                log.error("error evaluating trigger on event " + TriggerEvents.eventToString(event) + ": " + e.getMessage());
            }
            catch (Exception e) {
                log.error("error evaluating trigger on event " + TriggerEvents.eventToString(event), (Throwable)e);
            }
        }
    }

    private void evaluateTriggers(Workflow workflow, ValueStore valueStore, ConfluenceEvent event) throws WorkflowException {
        int i;
        Trigger[] triggers = workflow.getTriggers(event);
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug(event.getSource() + " fired " + ToStringBuilder.reflectionToString((Object)event));
            log.debug(workflow.toString().replaceAll("\n", "\\n"));
            log.debug("triggers " + Arrays.asList(triggers).toString().replaceAll("\n", "\\n"));
        }
        boolean[] flags = new boolean[triggers.length];
        for (i = 0; i < triggers.length; ++i) {
            flags[i] = triggers[i].evaluate(valueStore);
        }
        if (debug) {
            StringBuffer sb = new StringBuffer("[");
            for (int i2 = 0; i2 < triggers.length; ++i2) {
                sb.append(flags[i2]).append(" ");
            }
            sb.append("]");
            log.debug("Flags " + sb);
        }
        for (i = 0; i < triggers.length; ++i) {
            Trigger trigger;
            if (!flags[i] || !(trigger = triggers[i]).evaluate(valueStore)) continue;
            if (trigger.isQueue()) {
                if (log.isDebugEnabled()) {
                    log.debug("queueing trigger: " + trigger);
                }
                this.workflowActionManager.queueAction(workflow, valueStore, trigger);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("executing trigger, no queueing: " + trigger);
            }
            this.workflowActionManager.doAction(workflow, valueStore, trigger);
        }
    }

    protected void processHistoryEvent(ContentEvent event) {
        if (!this.darkFeatureManager.isEnabledForAllUsers("comalatech.workflows.newactivity.listener.disabled").orElse(true).booleanValue() && Arrays.asList(HANDLED_ACTIVITY_HISTORY_EVENTS).contains(event.getClass())) {
            this.eventHistoryManager.processHistoryEvent(event);
        }
    }
}

