/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.actions;

import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.opensymphony.util.TextUtils;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewPageCookieUtils {
    private static final Logger log = LoggerFactory.getLogger(ViewPageCookieUtils.class);
    protected static final int COOKIE_TTL = 3600;
    protected static final String DRAFT_FLAG = "draft";

    public static boolean isViewDraft(AbstractPage page, ServletActionContextCompatManager servletActionContextCompatManager) {
        String cookie = ViewPageCookieUtils.getCookieValue(ViewPageCookieUtils.makeCookieKey(page), servletActionContextCompatManager);
        if (!TextUtils.stringSet((String)cookie)) {
            return false;
        }
        return DRAFT_FLAG.equals(cookie);
    }

    public static void setViewPublished(AbstractPage page, ServletActionContextCompatManager servletActionContextCompatManager) {
        String key = ViewPageCookieUtils.makeCookieKey(page);
        if (!TextUtils.stringSet((String)ViewPageCookieUtils.getCookieValue(key, servletActionContextCompatManager))) {
            return;
        }
        ViewPageCookieUtils.removeCookie(key, servletActionContextCompatManager);
    }

    public static void setViewDraft(AbstractPage page, ServletActionContextCompatManager servletActionContextCompatManager) {
        ViewPageCookieUtils.setCookie(ViewPageCookieUtils.makeCookieKey(page), DRAFT_FLAG, 3600, servletActionContextCompatManager);
    }

    private static String makeCookieKey(AbstractPage page) {
        return "comalatech.awp.view." + page.getIdAsString();
    }

    private static Cookie setCookie(String key, String value, int ttl, ServletActionContextCompatManager servletActionContextCompatManager) {
        try {
            HttpServletRequest request = servletActionContextCompatManager.getRequest();
            if (request == null) {
                return null;
            }
            HttpServletResponse response = servletActionContextCompatManager.getResponse();
            String path = request.getContextPath();
            if (StringUtils.isEmpty((String)path)) {
                path = "/";
            }
            Cookie cookie = new Cookie(key, value);
            cookie.setMaxAge(ttl);
            cookie.setPath(path);
            cookie.setSecure(request.isSecure());
            response.addCookie(cookie);
            return cookie;
        }
        catch (Exception ex) {
            log.info("There has been an error setting the cookie key {} : {}", (Object)key, (Object)ex.getMessage());
            return null;
        }
    }

    private static void removeCookie(String key, ServletActionContextCompatManager servletActionContextCompatManager) {
        ViewPageCookieUtils.setCookie(key, null, 0, servletActionContextCompatManager);
    }

    private static String getCookieValue(String key, ServletActionContextCompatManager servletActionContextCompatManager) {
        Cookie cookie;
        HttpServletRequest request = servletActionContextCompatManager.getRequest();
        if (request != null && (cookie = ViewPageCookieUtils.getCookie(request, key)) != null) {
            return cookie.getValue();
        }
        return null;
    }

    private static Cookie getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies;
        if (!StringUtils.isEmpty((String)name) && (cookies = request.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(name)) continue;
                return cookies[i];
            }
        }
        return null;
    }
}

