/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.accesor;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.workflow.accesor.WorkflowsActivityRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.PageActivityRecord;
import com.comalatech.confluence.workflow.accesor.entity.WorkflowActivityRecord;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;

public class WorkflowsActivityRecordAccessorImpl
implements WorkflowsActivityRecordAccessor {
    private final EntityManagerProvider entityManagerProvider;
    private final DarkFeatureManager darkFeatureManager;
    private static final String WORKFLOW_ACTIVITY_KEY = "com.comalatech.states";
    private static final String READ_ACK_ACTIVITY_KEY = "com.comalatech.readack.activities";

    public WorkflowsActivityRecordAccessorImpl(EntityManagerProvider entityManagerProvider, DarkFeatureManager darkFeatureManager) {
        this.entityManagerProvider = entityManagerProvider;
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    public List<WorkflowActivityRecord> findAllWorkflowActivity() {
        String sqlQuery = this.darkFeatureManager.isEnabledForAllUsers("appfire.workflows.docactivity.upgrade.report.v2").orElse(false) != false ? "select content.space.id as SPACE_ID from BucketPropertySetItem propertySet inner join ContentEntityObject content on propertySet.entityId = content.id where content.space.id is not null and content.originalVersion is null and (propertySet.key = :states_key or propertySet.key = :read_key) group by content.space.id " : "select count(distinct propertySet.entityId) as NUM_PAGES, content.space.id as SPACE_ID from BucketPropertySetItem propertySet inner join ContentEntityObject content on propertySet.entityId = content.id where content.space.id is not null and content.originalVersion is null and (propertySet.key = :states_key or propertySet.key = :read_key) group by content.space.id order by NUM_PAGES desc";
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery(sqlQuery, Tuple.class);
        query.setParameter("states_key", (Object)WORKFLOW_ACTIVITY_KEY);
        query.setParameter("read_key", (Object)READ_ACK_ACTIVITY_KEY);
        List workflowActivityItems = query.getResultList();
        if (this.darkFeatureManager.isEnabledForAllUsers("appfire.workflows.docactivity.upgrade.report.v2").orElse(false).booleanValue()) {
            return workflowActivityItems.stream().map(record -> new WorkflowActivityRecord(null, (Long)record.get("SPACE_ID"))).collect(Collectors.toList());
        }
        return workflowActivityItems.stream().map(record -> new WorkflowActivityRecord((Long)record.get("NUM_PAGES"), (Long)record.get("SPACE_ID"))).collect(Collectors.toList());
    }

    @Override
    public List<PageActivityRecord> findAllWorkflowActivityBySpace(Long spaceId) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select distinct propertySet.entityId as CONTENT_ID from BucketPropertySetItem propertySet inner join ContentEntityObject content on propertySet.entityId = content.id where content.space.id = :space_id and (propertySet.key = :states_key or propertySet.key = :read_key) ", Tuple.class);
        query.setParameter("states_key", (Object)WORKFLOW_ACTIVITY_KEY);
        query.setParameter("read_key", (Object)READ_ACK_ACTIVITY_KEY);
        query.setParameter("space_id", (Object)spaceId);
        List pageWorkflowActivityItems = query.getResultList();
        return pageWorkflowActivityItems.stream().map(record -> new PageActivityRecord((Long)record.get("CONTENT_ID"), spaceId)).collect(Collectors.toList());
    }

    @Override
    public boolean hasWorkflowActivity(Long spaceId) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select propertySet.entityId from BucketPropertySetItem propertySet inner join ContentEntityObject content on propertySet.entityId = content.id where content.space.id = :space_id and (propertySet.key = :states_key or propertySet.key = :read_key) ", Tuple.class);
        query.setParameter("states_key", (Object)WORKFLOW_ACTIVITY_KEY);
        query.setParameter("read_key", (Object)READ_ACK_ACTIVITY_KEY);
        query.setParameter("space_id", (Object)spaceId);
        query.setMaxResults(1);
        List results = query.getResultList();
        return results != null && !results.isEmpty();
    }

    @Override
    public boolean hasWorkflowActivity(AbstractPage content) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("select propertySet.entityId from BucketPropertySetItem propertySet inner join ContentEntityObject content on propertySet.entityId = content.id where content.id = :content_id and (propertySet.key = :states_key or propertySet.key = :read_key) ", Tuple.class);
        query.setParameter("states_key", (Object)WORKFLOW_ACTIVITY_KEY);
        query.setParameter("read_key", (Object)READ_ACK_ACTIVITY_KEY);
        query.setParameter("content_id", (Object)content.getId());
        query.setMaxResults(1);
        List results = query.getResultList();
        return !results.isEmpty();
    }
}

