/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks.event.blogpost;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.event.TaskAssignEvent;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskUpdatedEvent;
import com.comalatech.confluence.tasks.model.Assignable;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.timers.TimerUtils;

public class BlogPostTaskAssignEvent
extends BlogPostTaskUpdatedEvent
implements TaskAssignEvent {
    private Assignment assignment;
    private boolean atTaskCreation;

    public BlogPostTaskAssignEvent(Object src, BlogPost blogPost, PageState state, PageTask task, Assignment assignment, boolean atTaskCreation) {
        super(src, blogPost, state, task, null, state.getPerformer());
        this.assignment = assignment;
        this.atTaskCreation = atTaskCreation;
    }

    @Override
    public Assignment getAssignment() {
        return this.assignment;
    }

    @Override
    public Assignable getAssignable() {
        return this.getTask();
    }

    @Override
    public AbstractPage getAbstractPage() {
        return this.getBlogPost();
    }

    public String toString() {
        if (this.getContent() == null || this.getTask() == null || this.assignment == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(TimerUtils.logDate(this.assignment.getDate())).append(" ").append(this.getContent());
        sb.append(" got task ").append(((PageTask)this.getTask()).getName()).append(" ").append(this.assignment);
        return sb.toString();
    }

    @Override
    public boolean isAtTaskCreation() {
        return this.atTaskCreation;
    }
}

