/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.comalatech.confluence.states.model.Activity;
import java.util.Date;
import java.util.Map;

public class DueDateRecord
extends Activity
implements com.comalatech.workflow.model.Activity {
    private Date dueDate;
    private boolean expiryTriggered;

    public DueDateRecord() {
    }

    public DueDateRecord(String settingUser, Date settingDate) {
        super(settingUser, settingDate);
    }

    public DueDateRecord(Date dueDate, String settingUser, Date settingDate) {
        super(settingUser, settingDate);
        this.dueDate = dueDate;
    }

    @Override
    public String getActivityId() {
        return "duedaterecord";
    }

    @Override
    public String getActivityKey() {
        return "duedaterecord";
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public boolean isExpiryTriggered() {
        return this.expiryTriggered;
    }

    public void setExpiryTriggered(boolean expiryTriggered) {
        this.expiryTriggered = expiryTriggered;
    }

    public boolean isExpired() {
        if (this.dueDate != null) {
            return new Date().after(this.dueDate);
        }
        return false;
    }

    @Override
    public String toString() {
        return "date: " + this.dueDate + " setby: " + this.getPerformer() + " on: " + this.getDate() + " expiry triggered: " + this.expiryTriggered;
    }

    @Override
    public Map<String, String> getAttributes() {
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dueDate == null ? 0 : this.dueDate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DueDateRecord other = (DueDateRecord)obj;
        if (this.dueDate == null) {
            if (other.dueDate != null) {
                return false;
            }
        } else {
            if (!this.dueDate.equals(other.dueDate)) {
                return false;
            }
            if (!this.expiryTriggered == other.expiryTriggered) {
                return false;
            }
        }
        return true;
    }
}

