/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.listener;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.AdHocEmail;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.readack.activeObjects.accessor.ReadAckRecordAccessor;
import com.comalatech.confluence.readack.activeObjects.entity.BaseReadAckRecord;
import com.comalatech.confluence.readack.activity.ReadAckActivityManager;
import com.comalatech.confluence.readack.activity.ReadAckCompletedActivityModel;
import com.comalatech.confluence.readack.events.ReadAckOverdueNotificationEvent;
import com.comalatech.confluence.readack.model.ReadAckSearchCriteria;
import com.comalatech.confluence.readack.model.ReadAckStatusType;
import com.comalatech.confluence.readack.service.ReadAckManager;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.workflow.event.readack.ReadAckCompletedEvent;
import com.comalatech.workflow.event.readack.ReadAckCreatedEvent;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadAckListener
extends WorkflowsListener {
    private static final Logger log = LoggerFactory.getLogger(ReadAckListener.class);
    private final AdhocNotificationService adhocNotificationService;
    private final ReadAckActivityManager readAckActivityManager;
    private final ReadAckManager readAckManager;
    private final ReadAckRecordAccessor readAckRecordAccessor;
    private final UserAccessor userAccessor;
    private final WorkflowNotificationConfigManager workflowNotificationConfigManager;

    public ReadAckListener(EventPublisher eventPublisher, AdhocNotificationService adhocNotificationService, ReadAckManager readAckManager, ReadAckActivityManager readAckActivityManager, ReadAckRecordAccessor readAckRecordAccessor, UserAccessor userAccessor, WorkflowNotificationConfigManager workflowNotificationConfigManager) {
        super(eventPublisher);
        this.adhocNotificationService = adhocNotificationService;
        this.readAckManager = readAckManager;
        this.readAckActivityManager = readAckActivityManager;
        this.readAckRecordAccessor = readAckRecordAccessor;
        this.userAccessor = userAccessor;
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
    }

    @EventListener
    public void notifyReadAck(ReadAckCreatedEvent event) {
        AbstractPage page = (AbstractPage)event.getContent();
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.READ_CONFIRMATION, page.getSpaceKey())) {
            ReadAckCreatedEventEmail email = new ReadAckCreatedEventEmail();
            email.setEntityId(page.getId());
            email.addContextProperty("pageTitle", page.getTitle());
            this.adhocNotificationService.sendEmail(email, event.getUsers());
        }
    }

    @EventListener
    public void cleanReadAckInfo(PageRemoveEvent event) {
        try {
            this.cleanReadAckInfo((AbstractPage)event.getPage());
        }
        catch (Exception e) {
            log.error("There was an error while processing event: " + event, (Throwable)e);
        }
    }

    @EventListener
    public void cleanReadAckInfo(BlogPostRemoveEvent event) {
        try {
            this.cleanReadAckInfo((AbstractPage)event.getBlogPost());
        }
        catch (Exception e) {
            log.error("There was an error while processing event: " + event, (Throwable)e);
        }
    }

    @EventListener
    public void sendNotification(ReadAckOverdueNotificationEvent event) {
        AbstractPage page = event.getPage();
        if (this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.READ_CONFIRMATION, page.getSpaceKey())) {
            ReadAckCreatedEventOverdueEmail email = new ReadAckCreatedEventOverdueEmail();
            ReadAckSearchCriteria criteria = new ReadAckSearchCriteria();
            criteria.setPageId(page.getId());
            criteria.setStatus(ReadAckStatusType.UserStatusType.PENDING);
            List<BaseReadAckRecord> readAckRecords = this.readAckRecordAccessor.search(criteria);
            HashSet<ConfluenceUser> notificationUsersList = new HashSet<ConfluenceUser>();
            for (BaseReadAckRecord readAckRecord : readAckRecords) {
                UserKey userInRecord = new UserKey(readAckRecord.getUserKey());
                ConfluenceUser userPending = this.userAccessor.getUserByKey(userInRecord);
                notificationUsersList.add(userPending);
            }
            email.setEntityId(page.getId());
            email.addContextProperty("pageTitle", page.getTitle());
            this.adhocNotificationService.sendEmail(email, notificationUsersList);
        }
    }

    private void cleanReadAckInfo(AbstractPage abstractPage) {
        this.readAckManager.removeReadAckUserRecords(abstractPage);
    }

    @EventListener
    public void addReadAckCompletedStats(ReadAckCompletedEvent event) {
        this.readAckActivityManager.addReadAckActivity((AbstractPage)event.getContent(), new ReadAckCompletedActivityModel(event.getAckTimestamp(), ((AbstractPage)event.getContent()).getVersion()));
    }

    private class ReadAckCreatedEventOverdueEmail
    extends AdHocEmail {
        public static final String PAGETITLE_KEY = "pageTitle";

        private ReadAckCreatedEventOverdueEmail() {
        }

        @Override
        public String getSubject() {
            return ConfluenceActionSupport.getTextStatic((String)"readack.notification.duedate.expired.subject", (Object[])new String[]{(String)this.getContextProperties().get(PAGETITLE_KEY)});
        }

        @Override
        public String getTemplateName() {
            return "read-ack-overdue";
        }
    }

    private class ReadAckCreatedEventEmail
    extends AdHocEmail {
        public static final String PAGETITLE_KEY = "pageTitle";

        private ReadAckCreatedEventEmail() {
        }

        @Override
        public String getSubject() {
            return ConfluenceActionSupport.getTextStatic((String)"readack.notification.created.subject", (Object[])new String[]{(String)this.getContextProperties().get(PAGETITLE_KEY)});
        }

        @Override
        public String getTemplateName() {
            return "read-ack-assigned";
        }
    }
}

