/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.service;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.comalatech.confluence.documentActivity.upgrade.accessor.SpaceUpgradeAccessor;
import com.comalatech.confluence.documentActivity.upgrade.accessor.entity.UpgradeTaskRecord;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.SpaceUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Status;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Upgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.UpgradeMetadata;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.UpgradeTask;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.documentActivity.upgrade.service.mapper.SpaceUpgradeMapper;
import com.comalatech.confluence.documentActivity.upgrade.service.mapper.UpgradeTaskMapper;
import com.comalatech.confluence.documentActivity.upgrade.utils.SupportPackageFile;
import com.comalatech.confluence.workflow.accesor.WorkflowsActivityRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.WorkflowActivityRecord;
import com.comalatech.confluence.workflow.analytics.UpgradeStatsGatherer;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.CompressionUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentActivityUpgradeServiceImpl
implements DocumentActivityUpgradeService {
    private static final Logger log = LoggerFactory.getLogger(DocumentActivityUpgradeServiceImpl.class);
    private static final String PAGE_UPGRADE_PENDING = "com.comalatech.workflows.page.upgrade.pending";
    private final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
    private final WorkflowsActivityRecordAccessor workflowsActivityAccessor;
    private final SpaceUpgradeAccessor spaceUpgradeAccessor;
    private final SpaceUpgradeMapper spaceUpgradeMapper;
    private final UpgradeTaskMapper upgradeTaskMapper;
    private final SpaceManager spaceManager;
    private final UpgradeStatsGatherer upgradeStatsGatherer;
    private final AccessModeService accessModeService;
    private final DarkFeatureManager darkFeatureManager;
    private final ComalaPropertiesSetManager comalaPropertiesSetManager;

    public DocumentActivityUpgradeServiceImpl(WorkflowsActivityRecordAccessor workflowsActivityAccessor, SpaceUpgradeAccessor spaceUpgradeAccessor, SpaceManager spaceManager, PageManager pageManager, LongRunningTaskManager longRunningTaskManager, UpgradeStatsGatherer upgradeStatsGatherer, AccessModeService accessModeService, DarkFeatureManager darkFeatureManager, ComalaPropertiesSetManager comalaPropertiesSetManager) {
        this.workflowsActivityAccessor = workflowsActivityAccessor;
        this.spaceUpgradeAccessor = spaceUpgradeAccessor;
        this.spaceManager = spaceManager;
        this.upgradeStatsGatherer = upgradeStatsGatherer;
        this.accessModeService = accessModeService;
        this.darkFeatureManager = darkFeatureManager;
        this.comalaPropertiesSetManager = comalaPropertiesSetManager;
        this.spaceUpgradeMapper = new SpaceUpgradeMapper(spaceManager, pageManager, darkFeatureManager);
        this.upgradeTaskMapper = new UpgradeTaskMapper(longRunningTaskManager);
    }

    @Override
    public Upgrade getUpgradeData() {
        List<SpaceUpgrade> spaceUpgrades = null;
        UpgradeMetadata upgradeMetadata = new UpgradeMetadata();
        List<WorkflowActivityRecord> spaceWorkflowActivities = this.workflowsActivityAccessor.findAllWorkflowActivity();
        if (spaceWorkflowActivities != null) {
            spaceUpgrades = ((Stream)spaceWorkflowActivities.stream().parallel()).map(this.spaceUpgradeMapper::fromRecordToModel).collect(Collectors.toList());
            ((Stream)spaceUpgrades.stream().parallel()).forEach(elem -> elem.setUpgradeTask(this.getSpaceUpgrade(elem.getSpace())));
            long totalPagesWithHistory = 0L;
            long totalSpacesWithHistory = 0L;
            long highestNumberPagesWithHistoryPerSpace = 0L;
            for (WorkflowActivityRecord record : spaceWorkflowActivities) {
                if (record == null) continue;
                if (record.getNumPages() != null) {
                    totalPagesWithHistory += record.getNumPages().longValue();
                    if (record.getNumPages() > highestNumberPagesWithHistoryPerSpace) {
                        highestNumberPagesWithHistoryPerSpace = record.getNumPages();
                    }
                }
                if (record.getSpaceId() == null) continue;
                ++totalSpacesWithHistory;
            }
            if (!this.darkFeatureManager.isEnabledForAllUsers("appfire.workflows.docactivity.upgrade.report.v2").orElse(true).booleanValue()) {
                upgradeMetadata.setTotalPagesWithHistory(totalPagesWithHistory);
            }
            upgradeMetadata.setTotalSpacesWithHistory(totalSpacesWithHistory);
            if (!this.darkFeatureManager.isEnabledForAllUsers("appfire.workflows.docactivity.upgrade.report.v2").orElse(true).booleanValue()) {
                upgradeMetadata.setHighestNumPagesWithWorkflowPerSpace(highestNumberPagesWithHistoryPerSpace);
            }
            if (!this.darkFeatureManager.isEnabledForAllUsers("appfire.workflows.docactivity.upgrade.report.v2").orElse(true).booleanValue()) {
                List pagesWithWorkflowPerSpace = spaceWorkflowActivities.stream().map(WorkflowActivityRecord::getNumPages).filter(Objects::nonNull).collect(Collectors.toList());
                double medianPagesWithWorkflowPerSpace = pagesWithWorkflowPerSpace.stream().sorted().skip(Math.max(0, (pagesWithWorkflowPerSpace.size() + 1) / 2 - 1)).limit(1 + (1 + pagesWithWorkflowPerSpace.size()) % 2).mapToLong(Long::intValue).average().orElse(0.0);
                upgradeMetadata.setMedianPagesWithWorkflowPerSpace(medianPagesWithWorkflowPerSpace);
            }
            upgradeMetadata.setTotalSpacesChecked((Long)this.upgradeStatsGatherer.getSpaceUpgradesCheckedAsStatField(spaceWorkflowActivities).getProcessor().execute());
            upgradeMetadata.setTotalDocActivityEntries((Long)this.upgradeStatsGatherer.getTotalDocActivityEntriesAsStatField(spaceWorkflowActivities).getProcessor().execute());
            upgradeMetadata.setTotalSpacesUpgraded((Long)this.upgradeStatsGatherer.getTotalSpacesUpgraded().getProcessor().execute());
            upgradeMetadata.setLatestSpaceUpgraded((Long)this.upgradeStatsGatherer.getLatestSpaceUpgraded().getProcessor().execute());
        }
        upgradeMetadata.setTotalSpaces(Long.valueOf(this.spaceManager.getAllSpaces().size()));
        boolean readOnlyMode = this.accessModeService.isReadOnlyAccessModeEnabled();
        return new Upgrade(spaceUpgrades, upgradeMetadata, readOnlyMode);
    }

    @Override
    public UpgradeTask getSpaceUpgrade(Space space) {
        UpgradeTaskRecord upgradeTaskRecord = this.spaceUpgradeAccessor.getSpaceUpgradeRecord(space);
        return this.upgradeTaskMapper.fromRecordToModel(upgradeTaskRecord, space);
    }

    @Override
    public void saveSpaceUpgrade(Space space, UpgradeTask upgradeTask) {
        UpgradeTaskRecord upgradeTaskRecord = this.upgradeTaskMapper.fromModelToRecord(upgradeTask);
        this.spaceUpgradeAccessor.saveSpaceUpgradeRecord(space, upgradeTaskRecord);
    }

    @Override
    public Path getSupportFile(Space space) throws IOException {
        Path zipPath = SupportPackageFile.generateFile(SupportPackageFile.getSpaceUpgradeBasePath(space.getKey()), "COMALA_UPGRADE_" + space.getKey() + "_" + this.FORMATTER.format(LocalDateTime.now()) + ".zip");
        CompressionUtils.compressToZip(SupportPackageFile.getDataBasePath(space.getKey(), null), zipPath);
        return zipPath;
    }

    private UpgradeTask getSpaceUpgradeStatus(Space space) {
        UpgradeTaskRecord upgradeTaskRecord = this.spaceUpgradeAccessor.getSpaceUpgradeRecord(space);
        UpgradeTask upgradeTask = this.upgradeTaskMapper.fromRecordToModel(upgradeTaskRecord, space);
        log.debug("Current space upgrade status {} for space {}", (Object)upgradeTaskRecord, (Object)space.getKey());
        if (upgradeTaskRecord == null) {
            if (!this.workflowsActivityAccessor.hasWorkflowActivity(space.getId())) {
                log.debug("Space {} has not any workflow activity...setting success as status value.", (Object)space.getKey());
                upgradeTask.setStatus(Status.UPGRADE_SUCCESS);
            }
            log.debug("Saving upgrade status {} for space {}", (Object)upgradeTask, (Object)space.getKey());
            this.saveSpaceUpgrade(space, upgradeTask);
        }
        return upgradeTask;
    }

    @Override
    public boolean isSpaceStatusUpgradeSuccess(AbstractPage page) {
        AbstractPage latestVersion = page.getLatestVersion();
        if (latestVersion != null && !this.darkFeatureManager.isEnabledForAllUsers("comalatech.workflows.newactivity.listener.disabled").orElse(true).booleanValue()) {
            UpgradeTask upgradeTask = this.getSpaceUpgradeStatus(latestVersion.getSpace());
            return Status.UPGRADE_SUCCESS.equals((Object)upgradeTask.getStatus());
        }
        return false;
    }

    @Override
    public void markPageAsUpgradePending(AbstractPage page) {
        this.comalaPropertiesSetManager.setTextProperty((ContentEntityObject)page, PAGE_UPGRADE_PENDING, "true");
    }

    @Override
    public boolean isPageUpgradePending(AbstractPage page) {
        String result = this.comalaPropertiesSetManager.getTextProperty((ContentEntityObject)page, PAGE_UPGRADE_PENDING);
        if (result != null) {
            return Boolean.parseBoolean(result);
        }
        return false;
    }

    @Override
    public void removePageUpgradePendingFlag(AbstractPage page) {
        this.comalaPropertiesSetManager.removeProperty((ContentEntityObject)page, PAGE_UPGRADE_PENDING);
    }

    @Override
    public boolean hasAlreadyBeenUpgraded(AbstractPage page) {
        return this.isSpaceStatusUpgradeSuccess(page) && !this.isPageUpgradePending(page);
    }
}

