/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.service.provider;

import com.comalatech.confluence.documentActivity.ao.accesor.ActivityRecordAccessor;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityRecord;
import com.comalatech.confluence.documentActivity.ao.mapper.ActivityRecordMapper;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQueryFilter;
import com.comalatech.confluence.documentActivity.service.provider.AbstractActivityProvider;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.workflow.model.document.activity.DocumentActivityActionTypesFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComalaActivityProvider
extends AbstractActivityProvider {
    private static final Logger log = LoggerFactory.getLogger(ComalaActivityProvider.class);
    private final ActivityRecordAccessor activityRecordAccessor;
    private final ActivityRecordMapper activityRecordMapper;
    private final Collection<String> compatibleTypes;

    public ComalaActivityProvider(ActivityRecordAccessor activityRecordAccessor, ActorUtils actorUtils) {
        super(actorUtils);
        this.activityRecordAccessor = activityRecordAccessor;
        this.activityRecordMapper = new ActivityRecordMapper(actorUtils);
        this.compatibleTypes = Arrays.stream(ActionType.Type.values()).filter(type -> type != ActionType.Type.PAGE && type != ActionType.Type.COMMENT).map(ActionType.Type::getValue).collect(Collectors.toList());
    }

    @Override
    public boolean shouldApply(InternalDocumentActivityQuery query) {
        InternalDocumentActivityQueryFilter filters = (InternalDocumentActivityQueryFilter)query.getFilters();
        return filters == null || !CollectionUtils.isNotEmpty(filters.getTypes()) || !Collections.disjoint(this.compatibleTypes, filters.getTypes().stream().map(DocumentActivityActionTypesFilter::getType).collect(Collectors.toList()));
    }

    @Override
    public List<Activity> get(InternalDocumentActivityQuery query) {
        if (log.isDebugEnabled()) {
            log.debug(MessageFormat.format("Getting comala activities for this query filters: {0}", query));
        }
        ArrayList<Activity> activities = new ArrayList<Activity>();
        if (this.shouldApply(query)) {
            List<BaseActivityRecord> activityRecords = this.activityRecordAccessor.search(query);
            if (log.isDebugEnabled()) {
                log.debug(MessageFormat.format("Comala activities provider returned {0} elements", activityRecords.size()));
            }
            activityRecords.forEach(elem -> {
                try {
                    activities.add(this.activityRecordMapper.recordToActivity((BaseActivityRecord)elem));
                }
                catch (WorkflowUserException | IOException e) {
                    log.error("Error mapping the activity record", (Throwable)e);
                }
            });
        } else {
            log.debug("Comala activities provider skipped");
        }
        return activities;
    }
}

