/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.AbstractPageAction;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.service.ClearWorkflowHistoryService;
import com.comalatech.confluence.workflow.events.blogpost.BlogPostWorkflowHistoryDeletedEventImpl;
import com.comalatech.confluence.workflow.events.page.PageWorkflowHistoryDeletedEventImpl;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReadOnlyAccessBlocked
public class RemovePageWorkflowAction
extends AbstractPageAction {
    private static final Logger log = LoggerFactory.getLogger(RemovePageWorkflowAction.class);
    private ClearWorkflowHistoryService clearWorkflowHistoryService;
    private TransactionalHostContextAccessor transactionalHostContextAccessor;
    private WorkflowPermissionManager workflowPermissionManager;
    private EventPublisher eventPublisher;
    private String submit;
    private boolean removeData;
    private boolean removeMetaData;

    public void setSubmit(String submit) {
        this.submit = submit;
    }

    public boolean isPermitted() {
        return this.workflowPermissionManager.canViewDrafts(this.getPage(), AuthenticatedUserThreadLocal.get());
    }

    public String execute() throws Exception {
        return "input";
    }

    public void setRemoveData(boolean removeData) {
        this.removeData = removeData;
    }

    public void setRemoveMetaData(boolean removeMetaData) {
        this.removeMetaData = removeMetaData;
    }

    public String doRemove() {
        if (this.submit != null) {
            AbstractPage page = this.getPage();
            try {
                this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRED, () -> this.clearPageWorkflowHistory(page));
            }
            catch (Exception e) {
                log.error("There has been an error processing the page " + page.getIdAsString(), (Throwable)e);
                return "error";
            }
        }
        return "success";
    }

    private boolean clearPageWorkflowHistory(AbstractPage page) {
        boolean successfulValidations = false;
        try {
            successfulValidations = this.clearWorkflowHistoryService.clearPageWorkflowHistory(page, this.removeData, this.removeMetaData);
            if (successfulValidations) {
                this.clearWorkflowHistoryService.clearUserMessages(Collections.singletonList(page.getIdAsString()));
                if (this.removeData) {
                    if (page instanceof Page) {
                        this.eventPublisher.publish((Object)new PageWorkflowHistoryDeletedEventImpl((Page)page));
                    } else if (page instanceof BlogPost) {
                        this.eventPublisher.publish((Object)new BlogPostWorkflowHistoryDeletedEventImpl((BlogPost)page));
                    }
                }
            }
            if (!successfulValidations && log.isDebugEnabled()) {
                log.debug("Deleting workflow history task completed with error");
            }
        }
        catch (Exception e) {
            log.error("Error removing workflow history from page " + page.getIdAsString(), (Throwable)e);
        }
        return successfulValidations;
    }

    public void setTransactionalHostContextAccessor(TransactionalHostContextAccessor transactionalHostContextAccessor) {
        this.transactionalHostContextAccessor = transactionalHostContextAccessor;
    }

    public void setClearWorkflowHistoryService(ClearWorkflowHistoryService clearWorkflowHistoryService) {
        this.clearWorkflowHistoryService = clearWorkflowHistoryService;
    }

    public void setWorkflowPermissionManager(WorkflowPermissionManager workflowPermissionManager) {
        this.workflowPermissionManager = workflowPermissionManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

