var requirejs = require || requirejs;
define("common",["jquery"],function($){
    var common={};

    /**
     * Converts stats into a json object with the values typecasted correctly
     * ie :
     *  "1" -> 1
     *  "true" -> true
     *  "string"-> "string"
     *  Also removes prefix from the params key
     *
     * @param params Dictionary of stats, this is, a list of key value pairs.
     * key value will have a  prefix (the plugin key) + "Stat" constant.
     * @param prefix value of the prefixed value. usually plugin key
     * @returns {{}} Json object
     */
     common.generateStats = function (params,prefix){
        var stats = {};
        var prefixLength = (prefix + 'Stats').length;
        Object.keys(params)
            .filter(function (key) {
                return key.startsWith(prefix + 'Stats');
            })
            .forEach(function (key) {
                var index = key.substring(prefixLength);
                index = index.charAt(0).toLowerCase() + index.slice(1);
                if (typeof params[key] === 'boolean') {
                    stats[index] = params[key];
                } else {
                    stats[index] = isNaN(params[key]) ? params[key] : +params[key]
                }
            });
        return stats;
    };

    common.analyticsAck = function (contextPath, pluginKey, trace) {
        $.ajax({
            type: 'POST',
            url: contextPath + '/rest/' + pluginKey + '/analytics/1/analytics/ack',
            headers: {'x-atlassian-token': 'no-check'},
            success: function () {
                trace && console.log('🔔🔔🔔 Acked stats');
            }
        });
    };

    return common;

});

