/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage.param;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.randombits.storage.BasedStorage;
import org.randombits.storage.StringBasedStorage;
import org.randombits.storage.param.Parameter;
import org.randombits.storage.param.ParameterStorage;

public class StringParameterStorage
extends StringBasedStorage
implements ParameterStorage<String> {
    protected Map<String, Parameter<String>> params = new HashMap<String, Parameter<String>>();
    protected Set<String> names = new HashSet<String>();
    private Set<String> uNames = Collections.unmodifiableSet(this.names);

    public StringParameterStorage() {
        super(BasedStorage.BoxType.Virtual);
    }

    public void addAll(Collection<Parameter<String>> params) {
        for (Parameter<String> param : params) {
            this.add(param);
        }
    }

    @Override
    public void add(Parameter<String> param) {
        this.checkReadOnly();
        this.params.put(param.getKey().toLowerCase(), param);
        this.names.add(param.getKey());
    }

    @Override
    protected Set<String> baseNameSet() {
        return this.uNames;
    }

    @Override
    protected String getBaseString(String name) {
        Parameter<String> param = this.params.get(name.toLowerCase());
        return param == null ? null : param.getValue();
    }

    @Override
    protected void setBaseString(String name, String value) {
        Parameter<String> param = this.params.get(name = name.toLowerCase());
        if (param == null) {
            this.add(new Parameter<String>(name, value));
        } else {
            param.setValue(value);
        }
    }

    @Override
    protected String[] getBaseStringArray(String name) {
        String value = this.getBaseString(name);
        if (value != null) {
            return value.split("(?<!\\\\),\\s*");
        }
        return null;
    }

    @Override
    protected void setBaseStringArray(String name, String[] value) {
        String stringValue = null;
        if (value != null) {
            StringBuilder out = new StringBuilder();
            for (int i = 0; i < value.length; ++i) {
                if (i != 0) {
                    out.append(", ");
                }
                out.append(value[i].replaceAll(",", "\\,"));
            }
        }
        this.setBaseString(name, stringValue);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean getBoolean(int index, boolean def) {
        return this.getBoolean(String.valueOf(index), def);
    }

    @Override
    public Boolean getBoolean(int index, Boolean def) {
        return this.getBoolean(String.valueOf(index), def);
    }

    @Override
    public Date getDate(int index, Date def) {
        return this.getDate(String.valueOf(index), def);
    }

    @Override
    public DateTime getDateTime(int index, DateTime def) {
        return this.getDateTime(String.valueOf(index), def);
    }

    @Override
    public double getDouble(int index, double def) {
        return this.getDouble(String.valueOf(index), def);
    }

    @Override
    public Double getDouble(int index, Double def) {
        return this.getDouble(String.valueOf(index), def);
    }

    @Override
    public int getInteger(int index, int def) {
        return this.getInteger(String.valueOf(index), def);
    }

    @Override
    public Integer getInteger(int index, Integer def) {
        return this.getInteger(String.valueOf(index), def);
    }

    @Override
    public long getLong(int index, long def) {
        return this.getLong(String.valueOf(index), def);
    }

    @Override
    public Long getLong(int index, Long def) {
        return this.getLong(String.valueOf(index), def);
    }

    @Override
    public Object getObject(int index, Object def) {
        return this.getObject(String.valueOf(index), def);
    }

    @Override
    public List<?> getObjectList(int index, List<?> def) {
        return this.getObjectList(String.valueOf(index), def);
    }

    @Override
    public String getString(int index, String def) {
        return this.getString(String.valueOf(index), def);
    }

    @Override
    public String[] getStringArray(int index, String[] def) {
        return this.getStringArray(String.valueOf(index), def);
    }

    @Override
    public Set<String> getStringSet(int index, Set<String> def) {
        return this.getStringSet(String.valueOf(index), def);
    }
}

