/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting.macro;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.RenderUtils;
import com.atlassian.renderer.v2.macro.MacroException;
import javax.servlet.http.HttpServletRequest;
import net.customware.confluence.reporting.ReportBuilder;
import net.customware.confluence.reporting.ReportException;
import org.apache.log4j.Logger;
import org.randombits.confluence.support.ConfluenceMacro;
import org.randombits.confluence.support.MacroInfo;
import org.randombits.confluence.support.ServletAssistant;

public abstract class AbstractReportingMacro
extends ConfluenceMacro {
    private static final Logger LOG = Logger.getLogger(AbstractReportingMacro.class);

    protected final String execute(MacroInfo info) throws MacroException {
        try {
            return this.report(info);
        }
        catch (ReportException e) {
            String path = null;
            HttpServletRequest request = ServletAssistant.getInstance().getRequest();
            if (request != null) {
                path = request.getRequestURI() + (request.getQueryString() != null ? "?" + request.getQueryString() : "");
            }
            if (path == null) {
                ContentEntityObject content;
                try {
                    content = ReportBuilder.getRootContent();
                }
                catch (ReportException e1) {
                    content = info.getContent();
                }
                if (content != null) {
                    path = content.getUrlPath();
                }
            }
            String onPath = path == null ? "" : " on \"" + path + "\"";
            LOG.info((Object)("Error while reporting" + onPath + ": " + e.getMessage()), (Throwable)e);
            return RenderUtils.blockError((String)"", (String)e.getMessage());
        }
    }

    protected abstract String report(MacroInfo var1) throws MacroException, ReportException;

    protected String renderWiki(String wiki, RenderMode renderMode) throws ReportException {
        return ReportBuilder.renderWiki(wiki, renderMode, this);
    }
}

