/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.upgrade.readConfirmation.migration.status;

import com.comalatech.confluence.upgrade.readConfirmation.migration.ReadConfirmationQueryMigrationStrings;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadConfirmationMigrationTableCheck
extends ReadConfirmationQueryMigrationStrings {
    private static final Logger log = LoggerFactory.getLogger(ReadConfirmationMigrationTableCheck.class);
    public static final String MIGRATION_BANDANA_KEY = "com.comalatech.workflows.readConfirmation.migration";

    static String countNumberOfRecordsFromOldTable(String type, Predicate<String> filter, UnaryOperator<String> format) {
        if (!filter.test(type)) {
            format = UnaryOperator.identity();
        }
        String COUNT_OLD_TABLE = "SELECT COUNT(*) as COUNT FROM %s";
        String query = String.format(COUNT_OLD_TABLE, format.apply("AO_26C053_CW_READ_ACK_RECORD"));
        log.info("Driver name: {}, Query{}", (Object)type, (Object)query);
        return query;
    }

    static String searchPreviousTableInInformationSchema(String type, Predicate<String> filter, UnaryOperator<String> format) {
        if (!filter.test(type)) {
            format = UnaryOperator.identity();
        }
        String COUNT_OLD_TABLE = type.contains("oracle") ? "SELECT TABLE_NAME FROM ALL_TABLES where TABLE_NAME='AO_26C053_CW_READ_ACK_RECORD'" : "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.%s where TABLE_NAME='AO_26C053_CW_READ_ACK_RECORD'";
        String query = String.format(COUNT_OLD_TABLE, format.apply("TABLES"));
        log.info("Driver name: {}, Query{}", (Object)type, (Object)query);
        return query;
    }

    public static class MigrationState {
        private long updateTimestamp;
        private String error;
        private Integer numRecords;
        private STATUS status;

        public MigrationState(STATUS status) {
            this.status = status;
        }

        public STATUS getStatus() {
            return this.status;
        }

        public void setStatus(STATUS status) {
            this.status = status;
        }

        public long getUpdateTimestamp() {
            return this.updateTimestamp;
        }

        public void setUpdateTimestamp(long updateTimestamp) {
            this.updateTimestamp = updateTimestamp;
        }

        public String getTimestampAsDate() {
            ZoneId z = ZoneId.systemDefault();
            ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.updateTimestamp), z);
            return zdt.toString();
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public Integer getNumRecords() {
            return this.numRecords;
        }

        public void setNumRecords(Integer numRecords) {
            this.numRecords = numRecords;
        }

        public static enum STATUS {
            PENDING,
            MIGRATED;

        }
    }
}

