/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.approval;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.mapper.ContentMapper;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalApprovedMapper;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalAssignedMapper;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalRejectedMapper;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalUnassignedMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApprovalsMapper
extends ContentMapper {
    private static final Logger log = LoggerFactory.getLogger(ApprovalsMapper.class);
    private final ApprovalApprovedMapper approvalApprovedMapper;
    private final ApprovalAssignedMapper approvalAssignedMapper;
    private final ApprovalRejectedMapper approvalRejectedMapper;
    private final ApprovalUnassignedMapper approvalUnassignedMapper;

    public ApprovalsMapper(PageManager pageManager, ActorUtils actorUtils) {
        super(pageManager);
        this.approvalApprovedMapper = new ApprovalApprovedMapper(actorUtils);
        this.approvalAssignedMapper = new ApprovalAssignedMapper(actorUtils);
        this.approvalRejectedMapper = new ApprovalRejectedMapper(actorUtils);
        this.approvalUnassignedMapper = new ApprovalUnassignedMapper(actorUtils);
    }

    public List<Activity> buildApprovalActivities(PageState state, ApprovalCheck approvalCheck) throws Exception {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        AbstractPage content = this.buildContent(state.getPage(), approvalCheck.getVersion());
        List<Approver> approvers = Arrays.asList(approvalCheck.getApprovers());
        if (!approvers.isEmpty()) {
            for (Approver approver : approvers) {
                if (approver.isApproved()) {
                    activities.add(this.approvalApprovedMapper.buildActivity(content, state, approvalCheck, approver, true));
                    continue;
                }
                activities.add(this.approvalRejectedMapper.buildActivity(content, state, approvalCheck, approver, true));
            }
            if (approvalCheck.isApproved()) {
                activities.add(this.approvalApprovedMapper.buildActivity(content, state, approvalCheck, approvers.get(approvers.size() - 1), false));
            } else {
                activities.add(this.approvalRejectedMapper.buildActivity(content, state, approvalCheck, approvers.get(approvers.size() - 1), false));
            }
        }
        content = this.buildContent(state.getPage(), state.getVersion());
        List<ApprovalCheck.AssigneeHistory> assignments = approvalCheck.getAssigneeHistory();
        if (assignments != null && !assignments.isEmpty()) {
            for (ApprovalCheck.AssigneeHistory assignment : assignments) {
                if (ApprovalCheck.AssigneeHistoryType.ASSIGNMENT.equals((Object)assignment.getType())) {
                    if (assignment.getAssignee() == null) continue;
                    activities.add(this.approvalAssignedMapper.buildActivity(content, state, approvalCheck, assignment));
                    continue;
                }
                if (!ApprovalCheck.AssigneeHistoryType.UNASSIGNMENT.equals((Object)assignment.getType()) || assignment.getAssignee() == null) continue;
                activities.add(this.approvalUnassignedMapper.buildActivity(content, approvalCheck, state, assignment));
            }
        }
        return activities;
    }
}

