/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActions.presenter;

import com.comalatech.confluence.documentActions.presenter.DocumentActionsPresenter;
import com.comalatech.confluence.documentActions.rest.model.DocumentActionsReport;
import com.comalatech.confluence.documentActions.services.model.search.SearchQuery;
import com.comalatech.confluence.documentActions.services.model.search.SortingFields;
import com.comalatech.confluence.documentActions.services.model.search.SortingOrder;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.comparators.ComparatorChain;

public class PaginatingAndSortingActionsPresenter
implements DocumentActionsPresenter<DocumentActionsReport, DocumentActionsReport> {
    private final SearchQuery searchQueryOptions;

    public PaginatingAndSortingActionsPresenter(SearchQuery searchQuery) {
        this.searchQueryOptions = searchQuery;
    }

    @Override
    public DocumentActionsReport present(DocumentActionsReport documentActions) {
        this.applySorting(documentActions);
        this.applyPagination(documentActions);
        return documentActions;
    }

    private Optional<ComparatorChain> buildSortingComparator(SearchQuery queryOptions) {
        ComparatorChain comparatorChain = queryOptions.getSortingFields().isEmpty() ? null : new ComparatorChain();
        for (SortingFields sortingField : queryOptions.getSortingFields()) {
            Comparator orderingComparator = SortingOrder.ASCENDING == queryOptions.getOrdering() ? Comparator.naturalOrder() : Comparator.reverseOrder();
            comparatorChain.addComparator(Comparator.comparing(sortingField.getKeyExtractor(), Comparator.nullsLast(orderingComparator)));
        }
        return Optional.ofNullable(comparatorChain);
    }

    private void applySorting(DocumentActionsReport documentActions) {
        Optional<ComparatorChain> actionsComparator = this.buildSortingComparator(this.searchQueryOptions);
        if (actionsComparator.isPresent()) {
            documentActions.getDocumentActions().sort(actionsComparator.get());
            documentActions.setSortingOrder(this.searchQueryOptions.getOrdering().getValue());
            documentActions.setSortingFields(this.searchQueryOptions.getSortingFields().stream().map(SortingFields::getValue).collect(Collectors.joining(",")));
        } else {
            documentActions.setSortingOrder(null);
            documentActions.setSortingFields(null);
        }
    }

    private void applyPagination(DocumentActionsReport documentActions) {
        int originalSize = documentActions.getDocumentActions().size();
        int start = Math.min(originalSize, this.searchQueryOptions.getPageNumber() * this.searchQueryOptions.getPageLimit());
        documentActions.getDocumentActions().subList(0, start).clear();
        int sizeAfterShrinkStart = documentActions.getDocumentActions().size();
        int end = Math.min(this.searchQueryOptions.getPageLimit(), sizeAfterShrinkStart);
        documentActions.getDocumentActions().subList(end, sizeAfterShrinkStart).clear();
        documentActions.setStart(this.searchQueryOptions.getPageNumber());
        documentActions.setLimit(this.searchQueryOptions.getPageLimit());
        documentActions.setSize(documentActions.getDocumentActions().size());
        documentActions.setTotalSize(originalSize);
    }
}

