/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.dataextractor;

import com.atlassian.confluence.core.ConfluencePropertySetManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.comalatech.confluence.dataextractor.ComalaPropertiesSetManager;
import com.opensymphony.module.propertyset.PropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultComalaPropertiesSetManager
implements ComalaPropertiesSetManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultComalaPropertiesSetManager.class);
    private final ConfluencePropertySetManager confluencePropertySetManager;
    public static final Integer STRING_VAL_TYPE = 5;
    public static final Integer TEXT_VAL_TYPE = 6;

    public DefaultComalaPropertiesSetManager(ConfluencePropertySetManager confluencePropertySetManager) {
        this.confluencePropertySetManager = confluencePropertySetManager;
    }

    @Override
    public void setTextProperty(ContentEntityObject content, String key, String data) {
        PropertySet propertySet = this.confluencePropertySetManager.getPropertySet((Object)content);
        if (propertySet != null) {
            propertySet.setText(key, data);
            if (log.isDebugEnabled()) {
                log.debug(key + " content property set with " + data + " value for content " + content.getIdAsString());
            }
        }
    }

    @Override
    public String getTextProperty(ContentEntityObject content, String key) {
        PropertySet propertySet = this.confluencePropertySetManager.getPropertySet((Object)content);
        if (propertySet != null && propertySet.exists(key)) {
            return propertySet.getText(key);
        }
        return null;
    }

    @Override
    public void setStringProperty(ContentEntityObject content, String key, String data) {
        PropertySet propertySet = this.confluencePropertySetManager.getPropertySet((Object)content);
        if (propertySet != null) {
            propertySet.setString(key, data);
            if (log.isDebugEnabled()) {
                log.debug(key + " content property set with " + data + " value for content " + content.getIdAsString());
            }
        }
    }

    @Override
    public String getStringProperty(ContentEntityObject content, String key) {
        PropertySet propertySet = this.confluencePropertySetManager.getPropertySet((Object)content);
        if (propertySet != null && propertySet.exists(key)) {
            return propertySet.getString(key);
        }
        return null;
    }

    @Override
    public void removeProperty(ContentEntityObject content, String key) {
        PropertySet propertySet = this.confluencePropertySetManager.getPropertySet((Object)content);
        if (propertySet != null) {
            propertySet.remove(key);
        }
    }

    @Override
    public Integer getTypeProperty(ContentEntityObject content, String key) {
        PropertySet propertySet = this.confluencePropertySetManager.getPropertySet((Object)content);
        if (propertySet != null && propertySet.exists(key)) {
            return propertySet.getType(key);
        }
        return null;
    }
}

