/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting.query;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.customware.confluence.reporting.Sortable;
import net.customware.confluence.reporting.query.AbstractQuery;
import net.customware.confluence.reporting.query.QueryException;
import org.apache.commons.collections.ComparatorUtils;
import org.randombits.confluence.filtering.criteria.Criteria;
import org.randombits.confluence.support.MacroInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSortableQuery<V>
extends AbstractQuery<V>
implements Sortable<V> {
    private Comparator<? super V> comparator;

    public AbstractSortableQuery(MacroInfo info) throws QueryException {
        super(info);
    }

    @Override
    protected void findItems(List<V> items, Criteria criteria) throws QueryException {
        this.findUnsortedItems(items, criteria);
        if (items.size() > 0 && this.comparator != null) {
            Collections.sort(items, this.comparator);
        }
    }

    protected abstract void findUnsortedItems(List<V> var1, Criteria var2) throws QueryException;

    @Override
    public boolean addComparator(Comparator<? super V> comparator) {
        this.comparator = this.comparator == null ? comparator : ComparatorUtils.chainedComparator(this.comparator, comparator);
        this.clearCache();
        return true;
    }

    protected void clearComparators() {
        this.comparator = null;
        this.clearCache();
    }

    @Override
    public Comparator<? super V> getComparator() {
        return this.comparator;
    }
}

