/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.adhoc.dao.AdhocWorkflowDao;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowLinkedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowUnlinkedEventImpl;
import com.comalatech.confluence.workflow.parser.WorkflowParser;
import com.comalatech.workflow.template.LinkedTemplateManager;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultLinkedTemplateManager
implements LinkedTemplateManager,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultLinkedTemplateManager.class);
    protected final AdhocWorkflowDao adhocWorkflowDao;
    protected final WorkflowParser workflowParser;
    protected final WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;
    protected final SpaceManager spaceManager;
    protected final EventPublisher eventPublisher;
    protected Map<String, com.comalatech.workflow.model.Workflow> globalWorkflowCache;
    protected int globalWorkflowCacheKey;
    private ApplicationContext applicationContext;
    private InternalWorkflowParameterManager workflowParameterManager;

    public DefaultLinkedTemplateManager(AdhocWorkflowDao adhocWorkflowDao, WorkflowParser workflowParser, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager, SpaceManager spaceManager, EventPublisher eventPublisher) {
        this.adhocWorkflowDao = adhocWorkflowDao;
        this.workflowParser = workflowParser;
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
        this.spaceManager = spaceManager;
        this.eventPublisher = eventPublisher;
        this.globalWorkflowCacheKey = -1;
        this.globalWorkflowCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(workflowAdvancedConfigurationManager.getCacheGlobalWorkflows()).build();
    }

    public void afterPropertiesSet() throws Exception {
        this.workflowParameterManager = (InternalWorkflowParameterManager)this.applicationContext.getBean("workflowParameterManager", InternalWorkflowParameterManager.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void addTemplateLink(String spaceKey, String templateName) {
        this.adhocWorkflowDao.setLinkedTemplate(spaceKey, templateName);
        Workflow workflow = null;
        try {
            workflow = this.workflowParser.parseWorkflow(this.adhocWorkflowDao.getWorkflowTemplateBody(null, templateName));
        }
        catch (WorkflowException workflowException) {
            // empty catch block
        }
        if (workflow != null) {
            this.workflowParameterManager.registerWorkflowParameters(spaceKey, workflow.getWorkflowParameters());
            Space space = this.spaceManager.getSpace(spaceKey);
            SpaceWorkflowLinkedEventImpl event = new SpaceWorkflowLinkedEventImpl(space, workflow);
            this.eventPublisher.publish((Object)event);
        }
    }

    @Override
    public void removeTemplateLink(String spaceKey, String templateName) {
        if (this.isLinked(spaceKey, templateName)) {
            this.adhocWorkflowDao.unlinkTemplate(spaceKey, templateName);
            Workflow workflow = new Workflow();
            workflow.setName(templateName);
            Space space = this.spaceManager.getSpace(spaceKey);
            if (space != null) {
                SpaceWorkflowUnlinkedEventImpl event = new SpaceWorkflowUnlinkedEventImpl(space, workflow);
                this.eventPublisher.publish((Object)event);
            }
        }
    }

    @Override
    public List<String> getLinkedTemplateNames(String spaceKey) {
        return this.adhocWorkflowDao.getLinkedTemplates(spaceKey);
    }

    @Override
    public List<String> getLinkedSpaces(String templateName) {
        return this.adhocWorkflowDao.getLinkedSpaces(templateName);
    }

    @Override
    public List<Space> getLinkedSpacesList(String templateName) {
        List<String> spaceLabelLinkKeys = this.getLinkedSpaces(templateName);
        return spaceLabelLinkKeys.stream().map(this::getSpace).filter(n -> n != null).collect(Collectors.toList());
    }

    @Override
    public boolean isLinked(String spaceKey, String templateName) {
        List<String> linkedSpaces = this.getLinkedSpaces(templateName);
        return linkedSpaces.contains(spaceKey);
    }

    @Override
    public List<com.comalatech.workflow.model.Workflow> getLinkedTemplates(String spaceKey) {
        return this.getWorkflowsFromTemplateNames(this.getLinkedTemplateNames(spaceKey));
    }

    @Override
    public void addSpaceLabelLink(String label, String templateName) {
        this.adhocWorkflowDao.setSpaceLabelLink(label, templateName);
    }

    @Override
    public void removeSpaceLabelLink(String label, String templateName) {
        this.adhocWorkflowDao.unlinkSpaceLabel(label, templateName);
    }

    @Override
    public List<String> getLinkedSpaceLabels(String templateName) {
        return this.adhocWorkflowDao.getLinkedLabels(templateName);
    }

    @Override
    public List<String> getLinkedLabelTemplateNames(String label) {
        return this.adhocWorkflowDao.getLinkedLabelTemplates(label);
    }

    @Override
    public List<com.comalatech.workflow.model.Workflow> getLinkedLabelTemplates(String label) {
        return this.getWorkflowsFromTemplateNames(this.getLinkedLabelTemplateNames(label));
    }

    protected List<com.comalatech.workflow.model.Workflow> getWorkflowsFromTemplateNames(List<String> globalWorkflowNames) {
        ArrayList<com.comalatech.workflow.model.Workflow> appliedWorkflows = new ArrayList<com.comalatech.workflow.model.Workflow>();
        int persistedCacheKey = this.adhocWorkflowDao.getProductionWorkflowsVersion(null);
        if (persistedCacheKey != this.globalWorkflowCacheKey) {
            if (log.isDebugEnabled()) {
                log.debug("globalWorkflowCacheKey: " + this.globalWorkflowCacheKey + "  persistedCacheKey: " + persistedCacheKey);
                log.debug("clearing global workflow cache");
            }
            this.globalWorkflowCache.clear();
            this.globalWorkflowCacheKey = persistedCacheKey;
        }
        for (String workflowName : globalWorkflowNames) {
            if (this.globalWorkflowCache.containsKey(workflowName)) {
                if (log.isDebugEnabled()) {
                    log.debug("getting global workflow template: " + workflowName + " from cache");
                }
                appliedWorkflows.add(this.globalWorkflowCache.get(workflowName));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("global workflow template not in cache, loading from markup: " + workflowName);
            }
            try {
                String markup = this.adhocWorkflowDao.getWorkflowTemplateBody(null, workflowName);
                if (log.isDebugEnabled()) {
                    log.debug("workflow markup:\n" + markup);
                }
                Workflow workflow = this.workflowParser.parseWorkflow(markup);
                appliedWorkflows.add(workflow);
                this.globalWorkflowCache.put(workflowName, workflow);
            }
            catch (WorkflowException e) {
                log.error("Error parsing global workflow template: " + workflowName, (Throwable)e);
            }
        }
        return appliedWorkflows;
    }

    private Space getSpace(String spaceKey) {
        Space newSpace = new Space();
        List allSpaceKeysInConfluence = this.spaceManager.getAllSpaces().stream().map(s -> s.getKey()).collect(Collectors.toList());
        if (!allSpaceKeysInConfluence.contains(spaceKey)) {
            return null;
        }
        newSpace.setKey(spaceKey);
        newSpace.setName(this.spaceManager.getSpace(spaceKey).getName());
        return newSpace;
    }
}

