/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork.listener;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mywork.event.task.AbstractTaskEvent;
import com.atlassian.mywork.model.Status;
import com.comalatech.confluence.adhoc.notification.AdhocNotificationService;
import com.comalatech.confluence.tasks.event.blogpost.BlogPostTaskDueDateUpdatedEvent;
import com.comalatech.confluence.tasks.event.page.PageTaskDueDateUpdatedEvent;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.WorkflowUserSettingsManager;
import com.comalatech.confluence.workflow.mywork.AdhocInAppNotificationService;
import com.comalatech.confluence.workflow.mywork.LocalTaskServiceAccessor;
import com.comalatech.confluence.workflow.mywork.TaskServiceAccessor;
import com.comalatech.confluence.workflow.mywork.notification.task.TaskAssigneeNotification;
import com.comalatech.confluence.workflow.mywork.notification.task.TaskCompletedNotification;
import com.comalatech.confluence.workflow.mywork.notification.task.TaskDueDateExpiredNotification;
import com.comalatech.confluence.workflow.mywork.notification.task.TaskUnassignedNotification;
import com.comalatech.confluence.workflow.mywork.notification.task.TaskUpdatedNotification;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.workflow.TaskService;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.event.TaskAssignEvent;
import com.comalatech.workflow.event.TaskCompleteEvent;
import com.comalatech.workflow.event.TaskDueDateExpiredEvent;
import com.comalatech.workflow.event.TaskUpdatedEvent;
import com.comalatech.workflow.model.Assignment;
import com.comalatech.workflow.model.ContentTask;
import com.comalatech.workflow.model.Task;
import com.opensymphony.util.TextUtils;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;

public class TaskMyWorkNotificationListener
extends WorkflowsListener {
    protected final AdhocInAppNotificationService adhocInAppNotificationService;
    protected final AdhocNotificationService adhocNotificationService;
    protected final WorkflowUserSettingsManager workflowUserSettingsManager;
    protected final WorkflowPermissionManager workflowPermissionManager;
    protected final UserAccessor userAccessor;
    protected final TaskServiceAccessor taskServiceAccessor;
    protected final LocalTaskServiceAccessor localTaskServiceAccessor;
    protected final TaskService awpTaskService;
    protected final ContentEntityManager contentEntityManager;
    protected final SettingsManager settingsManager;

    public TaskMyWorkNotificationListener(EventPublisher eventPublisher, AdhocInAppNotificationService adhocInAppNotificationService, AdhocNotificationService adhocNotificationService, WorkflowUserSettingsManager workflowUserSettingsManager, WorkflowPermissionManager workflowPermissionManager, UserAccessor userAccessor, TaskServiceAccessor taskServiceAccessor, TaskService awpTaskService, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, LocalTaskServiceAccessor localTaskServiceAccessor, SettingsManager settingsManager) {
        super(eventPublisher);
        this.adhocInAppNotificationService = adhocInAppNotificationService;
        this.adhocNotificationService = adhocNotificationService;
        this.workflowUserSettingsManager = workflowUserSettingsManager;
        this.workflowPermissionManager = workflowPermissionManager;
        this.userAccessor = userAccessor;
        this.taskServiceAccessor = taskServiceAccessor;
        this.awpTaskService = awpTaskService;
        this.contentEntityManager = contentEntityManager;
        this.localTaskServiceAccessor = localTaskServiceAccessor;
        this.settingsManager = settingsManager;
    }

    @EventListener
    public void taskAssigned(TaskAssignEvent event) {
        Assignment previousAssignment;
        List<? extends Assignment> taskAssignments;
        Assignment assignment = event.getAssignment();
        if (TextUtils.stringSet((String)assignment.getAssignee())) {
            TaskAssigneeNotification notification = new TaskAssigneeNotification(event);
            this.adhocInAppNotificationService.sendNotification(notification, Collections.singletonList(assignment.getAssignee()));
        }
        if ((taskAssignments = event.getTask().getAssignments()).size() > 1 && TextUtils.stringSet((String)(previousAssignment = taskAssignments.get(taskAssignments.size() - 2)).getAssignee()) && !previousAssignment.getAssignee().equals(assignment.getAssignee())) {
            TaskUnassignedNotification unassignmentNotification = new TaskUnassignedNotification(event);
            this.adhocInAppNotificationService.sendNotification(unassignmentNotification, Collections.singletonList(previousAssignment.getAssignee()));
        }
    }

    @EventListener
    public void taskCompleted(TaskCompleteEvent event) {
        String currentUser;
        Assignment assignment = event.getTask().getLastAssignment();
        if (assignment != null && !(currentUser = AuthenticatedUserThreadLocal.getUsername()).equals(assignment.getAssignee())) {
            TaskCompletedNotification notification = new TaskCompletedNotification(event);
            this.adhocInAppNotificationService.sendNotification(notification, Collections.singletonList(assignment.getAssignee()));
        }
    }

    @EventListener
    public void taskExpired(TaskDueDateExpiredEvent event) {
        Assignment assignment = event.getTask().getLastAssignment();
        if (assignment != null) {
            TaskDueDateExpiredNotification notification = new TaskDueDateExpiredNotification(event);
            this.adhocInAppNotificationService.sendNotification(notification, Collections.singletonList(assignment.getAssignee()));
        }
    }

    @EventListener
    public void taskUpdated(TaskUpdatedEvent event) {
        String assignee;
        String currentUser;
        if ((event instanceof PageTaskDueDateUpdatedEvent || event instanceof BlogPostTaskDueDateUpdatedEvent) && event.getTask().getLastAssignment() != null && event.getOldTask() != null && !(currentUser = AuthenticatedUserThreadLocal.getUsername()).equals(assignee = event.getTask().getLastAssignment().getAssignee())) {
            String description = "";
            if (!this.datesMatch(event.getOldTask().getDueDate(), event.getTask().getDueDate())) {
                SimpleDateFormat format = new SimpleDateFormat("EEEE, MMMM dd yyyy HH:mm");
                description = description + ConfluenceActionSupport.getTextStatic((String)"comalatech.awp.tasks.duedate.changed", (Object[])new String[]{format.format(event.getOldTask().getDueDate()), format.format(event.getTask().getDueDate())});
            }
            if (TextUtils.stringSet((String)description)) {
                TaskUpdatedNotification notification = new TaskUpdatedNotification(event, description);
                this.adhocInAppNotificationService.sendNotification(notification, Collections.singletonList(assignee));
            }
        }
    }

    protected boolean datesMatch(Date date1, Date date2) {
        if (date1 == null && date2 == null) {
            return true;
        }
        if (date1 != null && date2 != null) {
            return date1.equals(date2);
        }
        return false;
    }

    @EventListener
    public void workBoxTaskUpdated(com.atlassian.mywork.event.task.TaskUpdatedEvent taskEvent) {
        ContentEntityObject ceo;
        Task linkedAwpTask;
        if (this.isWorkflowTask((AbstractTaskEvent)taskEvent) && (linkedAwpTask = this.findLinkedTask(ceo = this.contentEntityManager.getById(this.getLinkedAwpPageId((AbstractTaskEvent)taskEvent).longValue()), taskEvent)) != null && taskEvent.getStatus().equals((Object)Status.DONE) && taskEvent.getOldStatus().equals((Object)Status.TODO)) {
            try {
                if (!linkedAwpTask.isCompleted()) {
                    this.awpTaskService.completeTask(ceo, linkedAwpTask.getActivityId(), "");
                }
            }
            catch (WorkflowException e) {
                e.printStackTrace();
            }
        }
    }

    protected Task findLinkedTask(ContentEntityObject ceo, com.atlassian.mywork.event.task.TaskUpdatedEvent event) {
        List<ContentTask> pageTasks = this.awpTaskService.getActiveTasks(ceo);
        for (ContentTask contentTask : pageTasks) {
            Assignment currentAssignment;
            if (!contentTask.getTask().getName().equals(event.getOldTask().getTitle()) || (currentAssignment = contentTask.getTask().getCurrentAssignment()) == null || !currentAssignment.getAssignee().equals(AuthenticatedUserThreadLocal.getUsername())) continue;
            return contentTask.getTask();
        }
        return null;
    }

    protected boolean isWorkflowTask(AbstractTaskEvent taskEvent) {
        String application = taskEvent.getTask().getApplication();
        return TextUtils.stringSet((String)application) && application.equals("com.comalatech.confluence.workflow.mywork");
    }

    protected Long getLinkedAwpPageId(AbstractTaskEvent taskEvent) {
        String[] splitId = taskEvent.getTask().getGlobalId().split("-");
        String pageIdString = splitId[0];
        Long pageId = null;
        try {
            pageId = new Long(pageIdString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return pageId;
    }
}

