/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.comalatech.confluence.analytics.StatField;
import com.comalatech.confluence.documentActivity.upgrade.accessor.SpaceUpgradeAccessor;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.SpaceUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Status;
import com.comalatech.confluence.documentActivity.upgrade.service.mapper.SpaceUpgradeMapper;
import com.comalatech.confluence.documentActivity.upgrade.service.mapper.UpgradeTaskMapper;
import com.comalatech.confluence.workflow.accesor.WorkflowsActivityRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.WorkflowActivityRecord;
import com.comalatech.confluence.workflow.analytics.catalog.BandanaKeysCatalog;
import com.comalatech.confluence.workflow.analytics.catalog.StatsCatalog;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class UpgradeStatsGatherer {
    private final WorkflowsActivityRecordAccessor workflowsActivityAccessor;
    private final SpaceUpgradeAccessor spaceUpgradeAccessor;
    private final SpaceUpgradeMapper spaceUpgradeMapper;
    private final UpgradeTaskMapper upgradeTaskMapper;
    private final SpaceManager spaceManager;
    private final BandanaManager bandanaManager;

    public UpgradeStatsGatherer(WorkflowsActivityRecordAccessor workflowsActivityAccessor, SpaceManager spaceManager, PageManager pageManager, LongRunningTaskManager longRunningTaskManager, SpaceUpgradeAccessor spaceUpgradeAccessor, BandanaManager bandanaManager) {
        this.workflowsActivityAccessor = workflowsActivityAccessor;
        this.spaceManager = spaceManager;
        this.spaceUpgradeAccessor = spaceUpgradeAccessor;
        this.bandanaManager = bandanaManager;
        this.spaceUpgradeMapper = new SpaceUpgradeMapper(spaceManager, pageManager);
        this.upgradeTaskMapper = new UpgradeTaskMapper(longRunningTaskManager);
    }

    public List<StatField> getAnalyticsFields() {
        ArrayList<StatField> fields = new ArrayList<StatField>();
        List<WorkflowActivityRecord> spaceWorkflowActivities = this.workflowsActivityAccessor.findAllWorkflowActivity();
        fields.add(this.getTotalSpacesAsStatField());
        fields.add(this.getTotalPagesWithHistoryAsStatField(spaceWorkflowActivities));
        fields.add(this.getTotalSpacesWithHistoryAsStatField(spaceWorkflowActivities));
        fields.add(this.getHighestNumberPagesWithHistoryPerSpaceAsStatField(spaceWorkflowActivities));
        fields.add(this.getMedianPagesWithHistoryPerSpaceAsStatField(spaceWorkflowActivities));
        fields.add(this.getSpaceUpgradesCheckedAsStatField(spaceWorkflowActivities));
        fields.add(this.getTotalDocActivityEntriesAsStatField(spaceWorkflowActivities));
        fields.add(this.getTotalSpacesUpgraded());
        fields.add(this.getLatestSpaceUpgraded());
        return fields;
    }

    public StatField getTotalDocActivityEntriesAsStatField(List<WorkflowActivityRecord> spaceWorkflowActivities) {
        return new StatField(StatsCatalog.STAT_DOC_ACTIVITY_ENTRIES_COUNTER, () -> {
            List<SpaceUpgrade> spaceUpgrades = spaceWorkflowActivities.stream().map(this.spaceUpgradeMapper::fromRecordToModel).collect(Collectors.toList());
            long[] totalDocActivityEntries = new long[]{0L};
            spaceUpgrades.forEach(elem -> {
                Long spaceTotalDocActivityEntries = (Long)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(elem.getSpace()), BandanaKeysCatalog.DOC_ACTIVITY_ENTRIES_COUNTER_KEY);
                if (spaceTotalDocActivityEntries != null) {
                    totalDocActivityEntries[0] = totalDocActivityEntries[0] + spaceTotalDocActivityEntries;
                }
            });
            return totalDocActivityEntries[0];
        });
    }

    public StatField getLatestSpaceUpgraded() {
        Long latestSpaceUpgraded = (Long)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), BandanaKeysCatalog.LATEST_SPACE_UPGRADED_KEY);
        return new StatField(StatsCatalog.STAT_LATEST_SPACE_UPGRADED, () -> latestSpaceUpgraded == null ? 0L : latestSpaceUpgraded);
    }

    public StatField getTotalSpacesUpgraded() {
        Long totalSpacesUpgraded = (Long)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(), BandanaKeysCatalog.SPACES_UPGRADED_COUNTER_KEY);
        return new StatField(StatsCatalog.STAT_SPACES_UPGRADED_COUNTER, () -> totalSpacesUpgraded == null ? 0L : totalSpacesUpgraded);
    }

    private StatField getTotalSpacesAsStatField() {
        return new StatField(StatsCatalog.STAT_SPACES_COUNTER, () -> (long)this.spaceManager.getAllSpaces().size());
    }

    private StatField getTotalPagesWithHistoryAsStatField(List<WorkflowActivityRecord> spaceWorkflowActivities) {
        return new StatField(StatsCatalog.STAT_PAGES_WITH_HISTORY_COUNTER, () -> spaceWorkflowActivities.stream().mapToLong(WorkflowActivityRecord::getNumPages).sum());
    }

    private StatField getTotalSpacesWithHistoryAsStatField(List<WorkflowActivityRecord> spaceWorkflowActivities) {
        return new StatField(StatsCatalog.STAT_SPACES_WITH_HISTORY_COUNTER, () -> spaceWorkflowActivities.stream().mapToLong(WorkflowActivityRecord::getSpaceId).count());
    }

    private StatField getHighestNumberPagesWithHistoryPerSpaceAsStatField(List<WorkflowActivityRecord> spaceWorkflowActivities) {
        return new StatField(StatsCatalog.STAT_HIGHEST_NUMBER_PAGES_WITH_WORKFLOW_PER_SPACE, () -> spaceWorkflowActivities.stream().mapToLong(WorkflowActivityRecord::getNumPages).max().orElse(0L));
    }

    private StatField getMedianPagesWithHistoryPerSpaceAsStatField(List<WorkflowActivityRecord> spaceWorkflowActivities) {
        return new StatField(StatsCatalog.STAT_MEDIAN_PAGES_WITH_WORKFLOW_PER_SPACE, () -> {
            List pagesWithWorkflowPerSpace = spaceWorkflowActivities.stream().map(WorkflowActivityRecord::getNumPages).collect(Collectors.toList());
            return pagesWithWorkflowPerSpace.stream().sorted().skip(Math.max(0, (pagesWithWorkflowPerSpace.size() + 1) / 2 - 1)).limit(1 + (1 + pagesWithWorkflowPerSpace.size()) % 2).mapToLong(Long::intValue).average().orElse(0.0);
        });
    }

    public StatField getSpaceUpgradesCheckedAsStatField(List<WorkflowActivityRecord> spaceWorkflowActivities) {
        return new StatField(StatsCatalog.STAT_SPACES_UPGRADE_CHECKED_COUNTER, () -> {
            List<SpaceUpgrade> spaceUpgrades = spaceWorkflowActivities.stream().map(this.spaceUpgradeMapper::fromRecordToModel).collect(Collectors.toList());
            spaceUpgrades.forEach(elem -> elem.setUpgradeTask(this.upgradeTaskMapper.fromRecordToModel(this.spaceUpgradeAccessor.getSpaceUpgradeRecord(elem.getSpace()), elem.getSpace())));
            return spaceUpgrades.stream().map(SpaceUpgrade::getUpgradeTask).filter(elem -> elem.getStatus().equals((Object)Status.SUCCESS) || elem.getStatus().equals((Object)Status.FAIL)).count();
        });
    }
}

