/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.comalatech.confluence.messaging.Message;
import com.comalatech.confluence.messaging.PageMessageManager;
import com.comalatech.confluence.workflow.InfiniteLoopWatchdog;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.activeobjects.accessor.QueuedJobEntityAccessor;
import com.comalatech.confluence.workflow.events.WorkflowCustomEvent;
import com.comalatech.confluence.workflow.model.Trigger;
import com.comalatech.confluence.workflow.tasks.manager.QueuedJobManager;
import com.comalatech.confluence.workflow.tasks.model.WorkflowActionModel;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultWorkflowActionManager
implements WorkflowActionManager,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowActionManager.class);
    private ApplicationContext applicationContext;
    private final WikiStyleRenderer wikiStyleRenderer;
    private final PageMessageManager pageMessageManager;
    private final EventPublisher eventPublisher;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private InfiniteLoopWatchdog infiniteLoopWatchdog;
    private QueuedJobManager queuedJobManager;
    public static String[] ACTIONS_TO_SPLIT = new String[]{"{add-restriction"};

    public DefaultWorkflowActionManager(WikiStyleRenderer wikiStyleRenderer, PageMessageManager pageMessageManager, EventPublisher eventPublisher, WorkflowConfigurationManager workflowConfigurationManager) {
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.pageMessageManager = pageMessageManager;
        this.eventPublisher = eventPublisher;
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.infiniteLoopWatchdog = new InfiniteLoopWatchdog(this.workflowConfigurationManager);
        this.queuedJobManager = (QueuedJobManager)this.applicationContext.getBean("queuedJobManager", QueuedJobManager.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void executeAction(ValueStore valueStore, String action, String newEventName, RenderContext renderContext) {
        String userMessage;
        if (log.isDebugEnabled()) {
            log.debug(valueStore.getPage() + " action " + action.trim().replaceAll("\n", " "));
        }
        renderContext.addParam((Object)"com.comalatech.execute", (Object)"yes");
        renderContext.addParam((Object)"valueStore", (Object)valueStore);
        LinkedList splitActions = Lists.newLinkedList();
        this.splitActionMacros(action, Lists.newArrayList((Object[])ACTIONS_TO_SPLIT), splitActions);
        boolean success = true;
        String message = null;
        for (String splitAction : splitActions) {
            message = this.wikiStyleRenderer.convertWikiToXHtml(renderContext, splitAction);
            String errorMessages = (String)renderContext.getParam((Object)"com.comalatech.log");
            if (!TextUtils.stringSet((String)errorMessages)) continue;
            log.error("Error Processing Workflow Trigger action page: " + valueStore.getPage() + "   trigger action: " + action + "   Error Message: " + errorMessages);
            valueStore.setErrorMessage(errorMessages);
            message = errorMessages;
            success = false;
            break;
        }
        if (TextUtils.stringSet((String)(userMessage = (String)renderContext.getParam((Object)"com.comalatech.user.message")))) {
            this.pageMessageManager.setMessage(valueStore.getPage(), null, AuthenticatedUserThreadLocal.get(), userMessage, Message.MacroParamStyle.WARNING.toString(), 0L);
        }
        if (newEventName != null) {
            this.eventPublisher.publish((Object)new WorkflowCustomEvent(this, valueStore.getPage(), newEventName, success, message));
        }
    }

    @Deprecated
    protected void splitActionMacros(String actions, List<String> splitters, List<String> actionsList) {
        if (splitters.size() == 0) {
            actionsList.add(actions);
            return;
        }
        String splitter = splitters.remove(0);
        for (String splitAction : Splitter.on((String)splitter).omitEmptyStrings().split((CharSequence)actions)) {
            if (splitAction.startsWith("{")) {
                this.splitActionMacros(splitAction, splitters, actionsList);
                continue;
            }
            actionsList.add(splitter + splitAction);
        }
    }

    @Override
    public void doAction(Workflow workflow, ValueStore valueStore, Trigger trigger) throws WorkflowException {
        PageContext renderContext = valueStore.getPage().toPageContext();
        if (this.disableWorkflowIfExceededThreshold(valueStore.getPage())) {
            String unrenderedMessage = "Disabling workflow:  detected a loop while processing the following action on page [" + valueStore.getPage().getTitle() + "]:\n{code}" + trigger.getTrimmedAction(valueStore.getEvent()) + "{code}";
            throw new WorkflowException(unrenderedMessage);
        }
        this.executeAction(valueStore, trigger.getTrimmedAction(valueStore.getEvent()), trigger.getNewEvent(), (RenderContext)renderContext);
    }

    @Override
    public void queueAction(Workflow workflow, ValueStore valueStore, Trigger trigger) {
        if (log.isDebugEnabled()) {
            log.debug(valueStore.getPage() + " action " + trigger.getAction(null).trim().replaceAll("\n", " "));
        }
        this.queueTask(trigger.getAction(null), trigger.getNewEvent(), valueStore.getPage().getId(), AuthenticatedUserThreadLocal.getUsername(), valueStore.getPropertiesMap(), workflow.getProperties());
    }

    private void queueTask(String action, String newEventName, long pageId, String userName, Map valueStoreProperties, Map workflowProperties) {
        this.queuedJobManager.addToQueue(QueuedJobEntityAccessor.JobType.WORKFLOW_ACTION, new WorkflowActionModel(pageId, action, userName, newEventName, workflowProperties, valueStoreProperties));
    }

    @Override
    public void queueAction(AbstractPage page, String action) {
        this.queueTask(action, null, page.getId(), AuthenticatedUserThreadLocal.getUsername(), Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    }

    public boolean disableWorkflowIfExceededThreshold(AbstractPage page) {
        return this.infiniteLoopWatchdog.hasExceededThreshold(AuthenticatedUserThreadLocal.getUsername(), page.getIdAsString());
    }
}

