/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks.model;

import com.comalatech.confluence.states.model.DueDateWorkflowElement;
import com.comalatech.confluence.tasks.model.TaskType;
import com.comalatech.confluence.workflowcontainer.model.Macroable;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class Task
extends DueDateWorkflowElement
implements Macroable {
    private TaskType type;
    private String name;
    private String assignee;
    private String note;

    public Task(String name, TaskType type, String assignee) {
        super(null);
        this.name = name;
        this.type = type;
        this.assignee = assignee;
        this.timers = new ArrayList();
    }

    protected Task(List conditions, TaskType type, String name) {
        super(conditions);
        this.type = type;
        this.name = name;
        this.timers = new ArrayList();
    }

    public Task(String name, TaskType type, String assignee, String note) {
        super(null);
        this.name = name;
        this.type = type;
        this.assignee = assignee;
        this.note = note;
        this.timers = new ArrayList();
    }

    public static boolean isValidTaskName(String name) {
        return TextUtils.stringSet((String)name) && !name.startsWith("'") && name.indexOf("\"") < 0 && !name.startsWith(">") && name.indexOf("|") < 0;
    }

    @Override
    public SerializableMacro toMacro() {
        SerializableMacro macro = new SerializableMacro("task", false);
        macro.addParameter("name", (Object)this.name);
        if (this.type != null && this.type != TaskType.DEFAULT) {
            macro.addParameter("type", (Object)this.type.toString());
        }
        macro.addParameter("assignee", (Object)this.assignee);
        String dueDate = this.getDueDate();
        if (dueDate != null) {
            macro.addParameter("duedate", (Object)dueDate);
        }
        macro.addParameter("note", (Object)this.note);
        return macro;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public TaskType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }
}

