/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.dao.sax;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.util.XMLUtils;
import com.atlassian.sal.api.user.UserKey;
import com.comalatech.confluence.states.dao.sax.DueDateConverterHelper;
import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.DeletionActivity;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.PageStateTimer;
import com.comalatech.confluence.states.model.StateChangeReason;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.model.Assignable;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.tasks.model.TaskType;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.dao.DaoHelper;
import com.comalatech.confluence.workflow.model.DueDateRecordAware;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PageStateConverter
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(PageStateConverter.class);
    private static final String PAGESTATE_QNAME = "pagestate";
    private static final String STATE_QNAME = "state";
    private static final String DATE_QNAME = "date";
    private static final String VERSION_QNAME = "version";
    private static final String USER_QNAME = "user";
    private static final String ATTACHMENT_QNAME = "attachment";
    private static final String ID_QNAME = "id";
    private static final String APPROVED_QNAME = "approved";
    private static final String COMMENT_QNAME = "comment";
    private static final String STATE_CHANGE_REASON_QNAME = "reason";
    private static final String STATE_DESCRIPTION_QNAME = "description";
    private static final String ASSIGNMENT_QNAME = "assignment";
    private static final String USERS_QNAME = "users";
    private static final String GROUPS_QNAME = "groups";
    private static final String TASK_QNAME = "task";
    private static final String TYPE_QNAME = "type";
    private static final String DELETED_TASKS_QNAME = "deletedTasks";
    private static final String DELETED_TASK_QNAME = "deletedTask";
    private static final String DUEDATE_QNAME = "duedate";
    private static final String TIMER_QNAME = "timer";
    private static final String NAME_QNAME = "name";
    private static final String TIMER_DUEDATE_QNAME = "duedate";
    private static final String TIMER_ACTIVE_QNAME = "active";
    private static final String TIMER_FIRED_QNAME = "fired";
    private static final String COMPLETION_QNAME = "completion";
    private static final String COMPLETION_APPROVALCHECKID = "approvalCheckId";
    private static final String COMPLETION_OUTCOME = "outcome";
    private static final String DELETION_QNAME = "deletion";
    private final UserAccessor userAccessor;
    private final SAXParserFactory saxParserFactory;
    private long id;
    private int version;
    private List<PageState> pageStates;
    private PageState pageState;
    private boolean inAttachment;
    private StringBuffer value;
    private static final String TAB2 = "  ";
    private static final String TAB4 = "    ";
    private static final String TAB6 = "      ";
    private PageStateTimer timer;
    private Stack<Activity> activityStack;
    private Map<String, String> userCache;

    public PageStateConverter(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
        this.userCache = new HashMap<String, String>();
        this.saxParserFactory = SAXParserFactory.newInstance();
        this.saxParserFactory.setValidating(false);
        this.saxParserFactory.setNamespaceAware(false);
    }

    @Override
    public void startDocument() throws SAXException {
        this.value = new StringBuffer();
        this.inAttachment = false;
        this.pageStates = new ArrayList<PageState>();
        this.activityStack = new Stack();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block16: {
            this.value = new StringBuffer();
            try {
                if (PAGESTATE_QNAME.equals(qName)) break block16;
                if (ATTACHMENT_QNAME.equals(qName)) {
                    this.inAttachment = true;
                    break block16;
                }
                if (ASSIGNMENT_QNAME.equals(qName)) {
                    this.activityStack.push(new Assignment(this.getUserName(attributes.getValue(USER_QNAME)), this.getDate(attributes.getValue(DATE_QNAME)), null, null, null, this.getDate(attributes.getValue("duedate"))));
                    break block16;
                }
                if (TIMER_QNAME.equals(qName)) {
                    String name = attributes.getValue(NAME_QNAME);
                    String dueDate = attributes.getValue("duedate");
                    boolean active = Boolean.parseBoolean(attributes.getValue(TIMER_ACTIVE_QNAME));
                    String fired = attributes.getValue(TIMER_FIRED_QNAME);
                    if (name == null || dueDate == null) {
                        throw new SAXException("timer parameter attributes missing");
                    }
                    this.timer = !active ? new PageStateTimer(name, TimerUtils.parseDate(dueDate), active, TimerUtils.parseDate(fired)) : new PageStateTimer(name, TimerUtils.parseDate(dueDate));
                    ((PageState)this.activityStack.peek()).addTimer(this.timer);
                    break block16;
                }
                if (TASK_QNAME.equals(qName) || DELETED_TASK_QNAME.equals(qName)) {
                    String name = attributes.getValue(NAME_QNAME);
                    TaskType type = TaskType.parse(attributes.getValue(TYPE_QNAME));
                    if (type == null) {
                        log.warn("invalid type task type {}, setting to 'default' and continuing parsing", (Object)attributes.getValue(TYPE_QNAME));
                        type = TaskType.DEFAULT;
                    }
                    PageTask task = new PageTask(this.getUserName(attributes.getValue(USER_QNAME)), name, type, this.getDate(attributes.getValue(DATE_QNAME)));
                    String id = attributes.getValue(ID_QNAME);
                    if (TextUtils.stringSet((String)id)) {
                        task.setId(Integer.parseInt(id));
                    }
                    this.activityStack.push(task);
                    break block16;
                }
                if (COMPLETION_QNAME.equals(qName)) {
                    TaskCompletion taskCompletion = new TaskCompletion(this.getUserName(attributes.getValue(USER_QNAME)), this.getDate(attributes.getValue(DATE_QNAME)));
                    String approvalCheckId = attributes.getValue(COMPLETION_APPROVALCHECKID);
                    if (TextUtils.stringSet((String)approvalCheckId)) {
                        try {
                            taskCompletion.setApprovalCheckId(Integer.parseInt(approvalCheckId));
                        }
                        catch (NumberFormatException e) {
                            throw new SAXException(e);
                        }
                    }
                    String outcome = attributes.getValue(COMPLETION_OUTCOME);
                    taskCompletion.setOutcome(outcome);
                    this.activityStack.push(taskCompletion);
                    break block16;
                }
                if (DELETION_QNAME.equals(qName)) {
                    DeletionActivity deletionActivity = new DeletionActivity(this.getUserName(attributes.getValue(USER_QNAME)), this.getDate(attributes.getValue(DATE_QNAME)));
                    this.activityStack.push(deletionActivity);
                } else if ("currentDueDateRecord".equals(qName) || "dueDateRecord".equals(qName)) {
                    DueDateRecord dueDateRecord = new DueDateRecord(this.getUserName(attributes.getValue(USER_QNAME)), this.getDate(attributes.getValue(DATE_QNAME)));
                    this.activityStack.push(dueDateRecord);
                }
            }
            catch (ParseException e) {
                throw new SAXException(e.getMessage());
            }
        }
    }

    private Date getDate(String value) throws ParseException {
        if (!TextUtils.stringSet((String)value)) {
            return null;
        }
        return TimerUtils.parseDate(value);
    }

    private String getUserName(String userNameOrKey) {
        if (StringUtils.isNotEmpty((CharSequence)userNameOrKey)) {
            String returnUser = this.userCache.get(userNameOrKey);
            if (returnUser == null) {
                ConfluenceUser user = this.userAccessor.getUserByName(userNameOrKey);
                if (user == null) {
                    user = this.userAccessor.getUserByKey(new UserKey(userNameOrKey));
                }
                returnUser = user == null ? userNameOrKey : user.getName();
                this.userCache.put(userNameOrKey, returnUser);
            }
            return returnUser;
        }
        return null;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (STATE_QNAME.equals(qName)) {
            PageState pageState = new PageState(this.getValue());
            this.activityStack.push(pageState);
        } else if (DATE_QNAME.equals(qName)) {
            try {
                this.activityStack.peek().setDate(this.getDate(this.getValue()));
            }
            catch (ParseException e) {
                throw new SAXException("error parsing date", e);
            }
        } else if (USER_QNAME.equals(qName)) {
            this.activityStack.peek().setUserName(this.getUserName(this.getValue()));
        } else if (STATE_DESCRIPTION_QNAME.equals(qName)) {
            ((PageState)this.activityStack.peek()).setDescription(this.getValue());
        } else if (VERSION_QNAME.equals(qName)) {
            this.version = Integer.parseInt(this.getValue());
            if (!this.inAttachment) {
                ((PageState)this.activityStack.peek()).setVersion(this.version);
            }
        } else if (ID_QNAME.equals(qName)) {
            this.id = Long.parseLong(this.getValue());
            if (!this.inAttachment) {
                ((PageState)this.activityStack.peek()).setId((int)this.id);
            }
        } else if (APPROVED_QNAME.equals(qName)) {
            ((PageState)this.activityStack.peek()).setApproved(!this.getValue().equals(Boolean.FALSE.toString()));
        } else if (PAGESTATE_QNAME.equals(qName)) {
            this.pageState = (PageState)this.activityStack.pop();
            this.pageStates.add(this.pageState);
        } else if (ATTACHMENT_QNAME.equals(qName)) {
            ((PageState)this.activityStack.peek()).addAttachment(this.id, this.version);
            this.inAttachment = false;
        } else if (COMMENT_QNAME.equals(qName)) {
            this.activityStack.peek().setComment(this.getValue().trim());
        } else if (USERS_QNAME.equals(qName)) {
            ((Assignment)this.activityStack.peek()).setAssignee(this.getUserName(this.getValue()));
        } else if (GROUPS_QNAME.equals(qName)) {
            ((Assignment)this.activityStack.peek()).setGroups(this.getValue());
        } else if (TIMER_QNAME.equals(qName)) {
            String note = this.getValue();
            if (TextUtils.stringSet((String)note)) {
                this.timer.setNote(this.getValue());
            }
        } else if (TASK_QNAME.equals(qName)) {
            PageTask task = (PageTask)this.activityStack.pop();
            ((PageState)this.activityStack.peek()).getPageTasks().addWithoutSettingId(task);
        } else if (DELETED_TASK_QNAME.equals(qName)) {
            PageTask task = (PageTask)this.activityStack.pop();
            ((PageState)this.activityStack.peek()).getPageTasks().addDeletedTask(task);
        } else if (ASSIGNMENT_QNAME.equals(qName)) {
            Assignment assignment = (Assignment)this.activityStack.pop();
            ((Assignable)((Object)this.activityStack.peek())).addAssignment(assignment);
        } else if (COMPLETION_QNAME.equals(qName)) {
            TaskCompletion taskCompletion = (TaskCompletion)this.activityStack.pop();
            ((PageTask)this.activityStack.peek()).complete(taskCompletion);
        } else if (DELETION_QNAME.equals(qName)) {
            DeletionActivity deletionActivity = (DeletionActivity)this.activityStack.pop();
            ((PageTask)this.activityStack.peek()).setDeletion(deletionActivity);
        } else if ("currentDueDateRecord".equals(qName)) {
            DueDateRecord dueDateRecord = (DueDateRecord)this.activityStack.pop();
            ((PageTask)this.activityStack.peek()).setCurrentDueDate(dueDateRecord);
        } else if ("dueDateRecord".equals(qName)) {
            DueDateRecord dueDateRecord = (DueDateRecord)this.activityStack.pop();
            ((DueDateRecordAware)((Object)this.activityStack.peek())).addDueDateHistory(dueDateRecord);
        } else if ("expiryTriggered".equals(qName)) {
            ((DueDateRecord)this.activityStack.peek()).setExpiryTriggered(Boolean.valueOf(this.getValue()));
        } else if ("duedate".equals(qName)) {
            try {
                ((DueDateRecord)this.activityStack.peek()).setDueDate(this.getDate(this.getValue()));
            }
            catch (ParseException e) {
                throw new SAXException("error parsing date", e);
            }
        } else if (STATE_CHANGE_REASON_QNAME.equals(qName)) {
            String reasonId = this.getValue();
            StateChangeReason reason = StateChangeReason.lookupById(reasonId);
            ((PageState)this.activityStack.peek()).setStateChangeReason(reason);
        }
    }

    public static String convertToXml(List<PageState> pageStates) {
        if (pageStates == null || pageStates.isEmpty()) {
            return null;
        }
        HashMap<String, String> userNamesCache = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder("<pagestates>\n");
        if (pageStates != null) {
            for (PageState pageState : pageStates) {
                PageStateConverter.appendPageState(sb, TAB2, pageState, userNamesCache);
            }
        }
        sb.append("</pagestates>\n");
        return sb.toString();
    }

    public static String convertToXml(PageState pageState) {
        if (pageState == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("");
        PageStateConverter.appendPageState(sb, "", pageState, null);
        return sb.toString();
    }

    public void extractFromXml(String xml) {
        this.pageStates = new ArrayList<PageState>();
        this.pageState = null;
        if (xml != null) {
            try {
                SAXParser parser = this.saxParserFactory.newSAXParser();
                parser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)this);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                log.error("Error Parsing pageState: " + xml, (Throwable)e);
            }
            catch (Exception e) {
                log.error("Runtime error Parsing pageState: " + xml, (Throwable)e);
            }
        }
    }

    private static void appendPageState(StringBuilder sb, String indent, PageState pageState, Map<String, String> userNameCache) {
        sb.append(indent).append("<pagestate>\n");
        PageStateConverter.append(sb, indent + TAB2, STATE_QNAME, pageState.getState());
        PageStateConverter.append(sb, indent + TAB2, ID_QNAME, Integer.toString(pageState.getId()));
        PageStateConverter.append(sb, indent + TAB2, DATE_QNAME, TimerUtils.getFormatter().format(pageState.getDate()));
        PageStateConverter.append(sb, indent + TAB2, VERSION_QNAME, Integer.toString(pageState.getVersion()));
        PageStateConverter.append(sb, indent + TAB2, USER_QNAME, DaoHelper.getUserNameOrKey(pageState.getPerformer(), userNameCache));
        PageStateConverter.append(sb, indent + TAB2, STATE_DESCRIPTION_QNAME, pageState.getDescription());
        PageStateConverter.append(sb, indent + TAB2, APPROVED_QNAME, Boolean.toString(pageState.isApproved()));
        PageStateConverter.append(sb, indent + TAB2, COMMENT_QNAME, pageState.getComment());
        if (pageState.getStateChangeReason() != null) {
            PageStateConverter.append(sb, indent + TAB2, STATE_CHANGE_REASON_QNAME, pageState.getStateChangeReason().getId() + "");
        }
        sb.append(indent + TAB2).append("<attachments>\n");
        for (PageState.AttachmentVersion attachmentVersion : pageState.getAttachmentVersions()) {
            sb.append(indent + TAB2).append("  <attachment>\n");
            PageStateConverter.append(sb, indent + TAB6, ID_QNAME, Long.toString(attachmentVersion.getId()));
            PageStateConverter.append(sb, indent + TAB6, VERSION_QNAME, Integer.toString(attachmentVersion.getVersion()));
            sb.append(indent + TAB2).append("  </attachment>\n");
        }
        sb.append(indent + TAB2).append("</attachments>\n");
        for (Assignment assignment : pageState.getAssignments()) {
            PageStateConverter.appendSingleUserAssignment(sb, indent + TAB2, assignment, userNameCache);
        }
        for (PageTask pageTask : pageState.getPageTasks().get()) {
            PageStateConverter.appendTask(sb, indent + TAB2, pageTask, userNameCache);
        }
        PageStateConverter.appendDeletedTasks(sb, indent + TAB2, pageState, userNameCache);
        for (PageStateTimer timer : pageState.getTimers()) {
            PageStateConverter.append(sb, indent + TAB2, timer);
        }
        DueDateConverterHelper.appendDueDateHistoryRecords(sb, TAB4, pageState.getDueDateHistory(), userNameCache);
        sb.append(indent).append("</pagestate>\n");
    }

    private static void appendTask(StringBuilder sb, String indent, PageTask task, Map<String, String> userNamesCache) {
        sb.append(indent);
        PageStateConverter.appendOpeningActivity(sb, task, null, userNamesCache);
        PageStateConverter.appendTaskCommon(sb, indent, task, userNamesCache);
        sb.append(indent).append("</").append(TASK_QNAME).append(">\n");
    }

    private static void appendDeletedTasks(StringBuilder sb, String indent, PageState pageState, Map<String, String> userNamesCache) {
        if (pageState.getPageTasks().getDeletedTasks() != null && pageState.getPageTasks().getDeletedTasks().size() > 0) {
            sb.append(indent).append("<").append(DELETED_TASKS_QNAME).append(">\n");
            for (PageTask pageTask : pageState.getPageTasks().getDeletedTasks()) {
                sb.append(indent + TAB4);
                PageStateConverter.appendOpeningActivity(sb, pageTask, DELETED_TASK_QNAME, userNamesCache);
                PageStateConverter.appendTaskCommon(sb, indent + TAB4, pageTask, userNamesCache);
                sb.append(indent + TAB4).append("</").append(DELETED_TASK_QNAME).append(">\n");
            }
            sb.append(indent).append("</").append(DELETED_TASKS_QNAME).append(">\n");
        }
    }

    private static void appendTaskCommon(StringBuilder sb, String indent, PageTask task, Map<String, String> userNamesCache) {
        for (Assignment assignment : task.getAssignments()) {
            PageStateConverter.appendSingleUserAssignment(sb, indent + TAB4, assignment, userNamesCache);
        }
        for (TaskCompletion completion : task.getCompletions()) {
            PageStateConverter.append(sb, indent + TAB4, completion, userNamesCache);
        }
        DueDateConverterHelper.appendDueDateRecord(sb, indent + TAB4, task.getCurrentDueDate(), "currentDueDateRecord", userNamesCache);
        DueDateConverterHelper.appendDueDateHistoryRecords(sb, indent + TAB4, task.getDueDateHistory(), userNamesCache);
        PageStateConverter.append(sb, indent + TAB4, COMMENT_QNAME, task.getComment());
        PageStateConverter.append(sb, indent + TAB4, task.getDeletion(), userNamesCache);
    }

    private static void appendSingleUserAssignment(StringBuilder sb, String indent, Assignment assignment, Map<String, String> userNamesCache) {
        sb.append(indent);
        PageStateConverter.appendOpeningActivity(sb, assignment, null, userNamesCache);
        PageStateConverter.append(sb, indent + TAB4, USERS_QNAME, DaoHelper.getUserNameOrKey(assignment.getAssignee(), userNamesCache));
        PageStateConverter.append(sb, indent + TAB4, GROUPS_QNAME, assignment.getGroups());
        PageStateConverter.append(sb, indent + TAB4, COMMENT_QNAME, assignment.getComment());
        sb.append(indent).append("</assignment>\n");
    }

    private static void append(StringBuilder sb, String indent, TaskCompletion completion, Map<String, String> userNamesCache) {
        sb.append(indent);
        PageStateConverter.appendOpeningActivity(sb, completion, null, userNamesCache);
        PageStateConverter.append(sb, indent + TAB4, COMMENT_QNAME, completion.getComment());
        sb.append(indent).append("</completion>\n");
    }

    private static void append(StringBuilder sb, String indent, DeletionActivity deletionActivity, Map<String, String> userNamesCache) {
        if (deletionActivity != null) {
            sb.append(indent + TAB4);
            PageStateConverter.appendOpeningActivity(sb, deletionActivity, null, userNamesCache);
            PageStateConverter.append(sb, indent + TAB4, COMMENT_QNAME, deletionActivity.getComment());
            sb.append(indent).append("</deletion>\n");
        }
    }

    private static StringBuilder append(StringBuilder sb, String indent, PageStateTimer timer) {
        sb.append(indent).append("<").append(TIMER_QNAME).append(" ").append(NAME_QNAME).append("=\"").append(XMLUtils.escape((String)timer.getName())).append("\" ").append("duedate").append("=\"").append(TimerUtils.getFormatter().format(timer.getDueDate())).append("\" ").append(TIMER_ACTIVE_QNAME).append("=\"").append(timer.isActive()).append("\"");
        if (timer.getFired() != null) {
            sb.append(" ").append(TIMER_FIRED_QNAME).append("=\"").append(TimerUtils.getFormatter().format(timer.getFired())).append("\">");
            if (TextUtils.stringSet((String)timer.getNote())) {
                sb.append(XMLUtils.escape((String)timer.getNote()));
            }
            sb.append("</").append(TIMER_QNAME).append(">\n");
        } else {
            sb.append("/>\n");
        }
        return sb;
    }

    private static StringBuilder appendOpeningActivity(StringBuilder sb, Activity activity, String activityKeyOverride, Map<String, String> userNamesCache) {
        sb.append("<");
        if (TextUtils.stringSet((String)activityKeyOverride)) {
            sb.append(activityKeyOverride);
        } else {
            sb.append(activity.getActivityKey());
        }
        if (activity.getAttributes() != null) {
            for (Map.Entry<String, String> attribute : activity.getAttributes().entrySet()) {
                if (attribute.getValue() == null) continue;
                sb.append(" ").append(attribute.getKey()).append("=\"").append(XMLUtils.escape((String)attribute.getValue())).append("\"");
            }
        }
        if (activity.getPerformer() != null) {
            sb.append(" ").append(USER_QNAME).append("=\"").append(XMLUtils.escape((String)DaoHelper.getUserNameOrKey(activity.getPerformer(), userNamesCache))).append("\"");
        }
        if (activity.getDate() != null) {
            sb.append(" ").append(DATE_QNAME).append("=\"").append(TimerUtils.getFormatter().format(activity.getDate())).append("\"");
        }
        sb.append(">\n");
        return sb;
    }

    private static StringBuilder append(StringBuilder sb, String indent, String element, String value) {
        if (TextUtils.stringSet((String)value)) {
            value = XMLUtils.escape((String)value);
            sb.append(indent).append('<').append(element).append('>').append(value).append("</").append(element).append(">\n");
        }
        return sb;
    }

    public List<PageState> getPageStates() {
        return this.pageStates;
    }

    public PageState getPageState() {
        return this.pageState;
    }

    public String getValue() {
        return this.value.toString();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.value.append(ch, start, length);
    }
}

