/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.rest.resources;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowVisibilityPermissionsRequired;
import com.comalatech.confluence.documentActivity.rest.model.DocumentActivityRequest;
import com.comalatech.confluence.documentActivity.rest.validator.PermissionValidator;
import com.comalatech.confluence.documentActivity.rest.validator.RequestValidator;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.workflow.DocumentActivityService;
import com.comalatech.workflow.model.document.activity.DocumentActivityResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="/documentactivity", produces="application/json")
@Path(value="/documentactivity")
@Produces(value={"application/json"})
public class DocumentActivityResource {
    private static final Logger log = LoggerFactory.getLogger(DocumentActivityResource.class);
    private final DocumentActivityService documentActivityService;
    private final RequestValidator requestValidator;
    private final PermissionValidator permissionValidator;

    public DocumentActivityResource(DocumentActivityService documentActivityService, PermissionValidator permissionValidator) {
        this.documentActivityService = documentActivityService;
        this.requestValidator = new RequestValidator();
        this.permissionValidator = permissionValidator;
    }

    @POST
    @Path(value="/pages")
    @WorkflowVisibilityPermissionsRequired
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Retrieves the report for a a group of pages.", response=DocumentActivityResult.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Activities were queried successfully"), @ApiResponse(code=400, message="Validation error of the input body"), @ApiResponse(code=401, message="Client is not authenticated"), @ApiResponse(code=403, message="User has not workflow visibility permissions"), @ApiResponse(code=500, message="Exception when trying to retrieve data for DocumentActivity")})
    public Response getReportForPages(@ApiParam(name="Document activity request") DocumentActivityRequest request) {
        try {
            this.requestValidator.validateTarget(request);
            this.requestValidator.validatePages(request.getFilters());
            Collection<Annotation> allAnnotations = new PermissionValidator.AnnotationGetterCommand(){}.getAllAnnotations();
            List<Long> pageIds = request.getFilters().getScope().getPageIds();
            this.permissionValidator.validatePages(allAnnotations, pageIds);
            DocumentActivityResult result = this.documentActivityService.getPagesActivity(pageIds, request.toQuery());
            return Response.ok((Object)result).build();
        }
        catch (IllegalArgumentException e) {
            String warningMsg = MessageFormat.format("Input validation error. The request: {0} caused this error: {1}", request, e.getMessage());
            log.warn(warningMsg);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ApplicationPermissionException e) {
            String warningMsg = MessageFormat.format("Permission validation error. {0} ", e.getMessage());
            log.warn(warningMsg);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            String errorMsg = MessageFormat.format("Unable to retrieve data for DocumentActivityReport for this request: {0}", request);
            log.error(errorMsg, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/spaces")
    @PermissionRequired(value={"ADMINISTER"})
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Retrieves the report for a a group of spaces.", response=DocumentActivityResult.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Activities were queried successfully"), @ApiResponse(code=400, message="Validation error of the input body"), @ApiResponse(code=401, message="Client is not authenticated"), @ApiResponse(code=403, message="User has not workflow visibility permissions"), @ApiResponse(code=500, message="Exception when trying to retrieve data for DocumentActivity")})
    public Response getReportForSpaces(@ApiParam(name="Document activity request") DocumentActivityRequest request) {
        try {
            this.requestValidator.validateTarget(request);
            this.requestValidator.validateSpaces(request.getFilters());
            Collection<Annotation> allAnnotations = new PermissionValidator.AnnotationGetterCommand(){}.getAllAnnotations();
            List<String> spaceKeys = request.getFilters().getScope().getSpaceKeys();
            this.permissionValidator.validateSpaces(allAnnotations, spaceKeys);
            DocumentActivityResult result = this.documentActivityService.getSpacesActivity(spaceKeys, request.toQuery());
            return Response.ok((Object)result).build();
        }
        catch (IllegalArgumentException e) {
            String warningMsg = MessageFormat.format("Input validation error. The request: {0} caused this error: {1}", request, e.getMessage());
            log.warn(warningMsg);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (ApplicationPermissionException e) {
            String warningMsg = MessageFormat.format("Permission validation error. {0} ", e.getMessage());
            log.warn(warningMsg);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            String errorMsg = MessageFormat.format("Unable to retrieve data for DocumentActivityReport for this request: {0}", request);
            log.error(errorMsg, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

