/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.rest.model;

import com.comalatech.confluence.documentActivity.api.service.model.PublicDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryFilter;
import com.comalatech.workflow.model.document.activity.SortingOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@ApiModel(description="This is the specification of the requested data.")
public class DocumentActivityRequest {
    private static final int DEFAULT_RESULTS_LIMIT = 100;
    @ApiModelProperty(value="The order for the sorting of activities, ascending or descending on the moment they occurred", example="desc")
    private SortingOrder sorting;
    @ApiModelProperty(value="Fields to be used for filtering results.")
    private DocumentActivityQueryFilter filters;
    @ApiModelProperty(value="Offset used to paginate results within a certain query.", example="0")
    private int offset = 0;
    @ApiModelProperty(value="Limits the maximum amount of activities retrieved.", example="100")
    private int limit = 100;

    public PublicDocumentActivityQuery toQuery() {
        PublicDocumentActivityQuery query = new PublicDocumentActivityQuery();
        query.setLimit(100);
        query.setFilters(this.filters);
        query.setOrder(this.sorting != null ? this.sorting : SortingOrder.desc);
        query.setOffset(this.offset);
        query.setLimit(this.limit);
        return query;
    }

    public static DocumentActivityRequestBuilder builder() {
        return new DocumentActivityRequestBuilder();
    }

    public SortingOrder getSorting() {
        return this.sorting;
    }

    public DocumentActivityQueryFilter getFilters() {
        return this.filters;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setSorting(SortingOrder sorting) {
        this.sorting = sorting;
    }

    public void setFilters(DocumentActivityQueryFilter filters) {
        this.filters = filters;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentActivityRequest)) {
            return false;
        }
        DocumentActivityRequest other = (DocumentActivityRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SortingOrder this$sorting = this.getSorting();
        SortingOrder other$sorting = other.getSorting();
        if (this$sorting == null ? other$sorting != null : !((Object)((Object)this$sorting)).equals((Object)other$sorting)) {
            return false;
        }
        DocumentActivityQueryFilter this$filters = this.getFilters();
        DocumentActivityQueryFilter other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        return this.getLimit() == other.getLimit();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentActivityRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SortingOrder $sorting = this.getSorting();
        result = result * 59 + ($sorting == null ? 43 : ((Object)((Object)$sorting)).hashCode());
        DocumentActivityQueryFilter $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getLimit();
        return result;
    }

    public String toString() {
        return "DocumentActivityRequest(sorting=" + (Object)((Object)this.getSorting()) + ", filters=" + this.getFilters() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }

    public DocumentActivityRequest() {
    }

    public DocumentActivityRequest(SortingOrder sorting, DocumentActivityQueryFilter filters, int offset, int limit) {
        this.sorting = sorting;
        this.filters = filters;
        this.offset = offset;
        this.limit = limit;
    }

    public static class DocumentActivityRequestBuilder {
        private SortingOrder sorting;
        private DocumentActivityQueryFilter filters;
        private int offset;
        private int limit;

        DocumentActivityRequestBuilder() {
        }

        public DocumentActivityRequestBuilder sorting(SortingOrder sorting) {
            this.sorting = sorting;
            return this;
        }

        public DocumentActivityRequestBuilder filters(DocumentActivityQueryFilter filters) {
            this.filters = filters;
            return this;
        }

        public DocumentActivityRequestBuilder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public DocumentActivityRequestBuilder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public DocumentActivityRequest build() {
            return new DocumentActivityRequest(this.sorting, this.filters, this.offset, this.limit);
        }

        public String toString() {
            return "DocumentActivityRequest.DocumentActivityRequestBuilder(sorting=" + (Object)((Object)this.sorting) + ", filters=" + this.filters + ", offset=" + this.offset + ", limit=" + this.limit + ")";
        }
    }
}

