/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor.builder.report;

import com.comalatech.confluence.documentActivity.ao.accesor.builder.report.FilterBuilder;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryFilter;
import com.comalatech.workflow.model.document.activity.DocumentActivityActionTypesFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.java.ao.Query;

public class TypesFilterBuilder
implements FilterBuilder {
    @Override
    public Query build(DocumentActivityQuery query) {
        return this.getQuery(query, false);
    }

    @Override
    public Query build(DocumentActivityQuery query, boolean aliasRequired) {
        return this.getQuery(query, aliasRequired);
    }

    private Query getQuery(DocumentActivityQuery query, boolean aliasRequired) {
        StringBuilder clause;
        DocumentActivityQueryFilter filters = (DocumentActivityQueryFilter)query.getFilters();
        if (filters == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        List<DocumentActivityActionTypesFilter> types = filters.getTypes();
        if (types != null && !types.isEmpty()) {
            clause = new StringBuilder("( ");
            for (DocumentActivityActionTypesFilter type : types) {
                if (type.getSubtypes() != null && !type.getSubtypes().isEmpty()) {
                    String placeHolder = type.getSubtypes().stream().map(s -> "?").collect(Collectors.joining(","));
                    clause.append("(").append(aliasRequired ? "activity." : "").append("ACTION_TYPE = ? AND ").append(aliasRequired ? "activity." : "").append("ACTION_SUBTYPE IN (").append(placeHolder).append(") )");
                    values.add(type.getType());
                    values.addAll(type.getSubtypes());
                } else if (type.getType().equals(ActionType.Type.STATE.getValue())) {
                    clause.append(" ( ").append(aliasRequired ? "activity." : "").append("ACTION_TYPE = ? AND ").append(aliasRequired ? "activity." : "").append("ACTION_SUBTYPE != ? )");
                    values.add(type.getType());
                    values.add(ActionType.Subtype.STATE_CLOSED.getValue());
                } else if (type.getType().equals(ActionType.Type.APPROVAL.getValue())) {
                    clause.append(" ( ").append(aliasRequired ? "activity." : "").append("ACTION_TYPE = ? AND ").append(aliasRequired ? "activity." : "").append("ACTION_SUBTYPE NOT IN (?,?) )");
                    values.add(type.getType());
                    values.add(ActionType.Subtype.APPROVAL_FULLY_APPROVED.getValue());
                    values.add(ActionType.Subtype.APPROVAL_FULLY_REJECTED.getValue());
                } else {
                    clause.append(aliasRequired ? "activity." : "").append("ACTION_TYPE = ?");
                    values.add(type.getType());
                }
                clause.append(" OR ");
            }
            clause = new StringBuilder(clause.substring(0, clause.length() - 3) + ")");
        } else {
            clause = new StringBuilder().append(aliasRequired ? "activity." : "").append("ACTION_SUBTYPE NOT IN (?,?,?) ");
            values.add(ActionType.Subtype.STATE_CLOSED.getValue());
            values.add(ActionType.Subtype.APPROVAL_FULLY_APPROVED.getValue());
            values.add(ActionType.Subtype.APPROVAL_FULLY_REJECTED.getValue());
        }
        return Query.select().where(clause.toString(), values.toArray());
    }

    @Override
    public boolean shouldApply(DocumentActivityQuery query) {
        return true;
    }
}

