/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor.builder.report;

import com.comalatech.confluence.documentActivity.ao.accesor.builder.report.FilterBuilder;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryFilter;
import java.util.ArrayList;
import net.java.ao.Query;

public class DateRangeFilterBuilder
implements FilterBuilder {
    @Override
    public Query build(DocumentActivityQuery query) {
        return this.getQuery(query, false);
    }

    @Override
    public Query build(DocumentActivityQuery query, boolean aliasRequired) {
        return this.getQuery(query, aliasRequired);
    }

    private Query getQuery(DocumentActivityQuery query, boolean aliasRequired) {
        StringBuilder dateRangeWhere = new StringBuilder();
        ArrayList<Long> dateRangeParams = new ArrayList<Long>();
        DocumentActivityQueryFilter filters = (DocumentActivityQueryFilter)query.getFilters();
        if (filters.getFromDate() != null) {
            dateRangeWhere.append(aliasRequired ? "activity." : "").append("MOMENT").append(" >= ? ");
            dateRangeParams.add(filters.getFromDate());
        }
        if (filters.getToDate() != null) {
            if (!dateRangeParams.isEmpty()) {
                dateRangeWhere.append("AND ");
            }
            dateRangeWhere.append(aliasRequired ? "activity." : "").append("MOMENT").append(" <= ? ");
            dateRangeParams.add(filters.getToDate());
        }
        return dateRangeParams.isEmpty() ? null : Query.select().where(dateRangeWhere.toString(), dateRangeParams.toArray());
    }

    @Override
    public boolean shouldApply(DocumentActivityQuery query) {
        DocumentActivityQueryFilter filters = (DocumentActivityQueryFilter)query.getFilters();
        return filters.getFromDate() != null || filters.getToDate() != null;
    }
}

