/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.ao.accesor.builder;

import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.AbstractFilterProcessor;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.report.DateRangeFilterBuilder;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.report.FilterBuilder;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.report.MomentFilterBuilder;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.report.ScopeFilterBuilder;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.report.StateFilterBuilder;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.report.TypesFilterBuilder;
import com.comalatech.confluence.documentActivity.ao.accesor.builder.report.UsersFilterBuilder;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQuery;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.java.ao.Query;

public class FiltersProcessor
extends AbstractFilterProcessor {
    private final List<FilterBuilder> filterBuilders;
    private final FilterBuilder usersFilterBuilder = new UsersFilterBuilder();

    public FiltersProcessor(SpaceManager spaceManager) {
        this.filterBuilders = Arrays.asList(new StateFilterBuilder(), new ScopeFilterBuilder(spaceManager), new MomentFilterBuilder(), new DateRangeFilterBuilder(), new TypesFilterBuilder(), this.usersFilterBuilder);
    }

    public void addFiltersToQuery(Query query, DocumentActivityQuery criteria) {
        List<Query> filters = this.filterBuilders.stream().filter(filterBuilder -> filterBuilder.shouldApply(criteria)).map(filterBuilder -> filterBuilder.build(criteria, this.isAliasRequired(criteria))).filter(Objects::nonNull).collect(Collectors.toList());
        this.addFilters(query, filters);
    }

    private boolean isAliasRequired(DocumentActivityQuery criteria) {
        if (Objects.isNull(criteria) || Objects.isNull(criteria.getFilters())) {
            return false;
        }
        List<String> participants = criteria.getFilters().getParticipants();
        return !Objects.isNull(participants) && !participants.isEmpty();
    }

    public boolean needsDetailQuery(DocumentActivityQuery query) {
        return ((UsersFilterBuilder)this.usersFilterBuilder).shouldApplyToParticipants(query);
    }
}

