/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhocworkflows.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.comalatech.confluence.adhocworkflows.rest.AbstractAdhocResources;
import com.comalatech.confluence.adhocworkflows.rest.AbstractRestResources;
import com.comalatech.confluence.adhocworkflows.rest.model.ApprovalRequest;
import com.comalatech.confluence.adhocworkflows.rest.permissions.ViewWorkflowPermissionRequired;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.util.JsonSerialiserUtil;
import com.comalatech.confluence.workflow.ApprovalRolesManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.workflow.ApprovalService;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.WorkflowHandler;
import com.comalatech.workflow.model.Assignee;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/approval")
public class ApprovalResources
extends AbstractAdhocResources {
    protected final ApprovalRolesManager approvalRolesManager;
    protected final ApprovalService approvalService;
    protected final UserAccessor userAccessor;

    public ApprovalResources(PageManager pageManager, PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, AccessModeService accessModeService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowHandler workflowHandler, UserSearchManager userSearchManager, BootstrapManager bootstrapManager, ApprovalRolesManager approvalRolesManager, ApprovalService approvalService, UserAccessor userAccessor) {
        super(pageManager, permissionManager, workflowPermissionManager, spaceManager, spacePermissionManager, accessModeService, workflowsFeatureManager, workflowConfigurationManager, workflowHandler, userSearchManager, bootstrapManager);
        this.approvalRolesManager = approvalRolesManager;
        this.approvalService = approvalService;
        this.userAccessor = userAccessor;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/approve/")
    public Response approve(@PathParam(value="pageId") long pageId, ApprovalRequest request) {
        return this.approveOrReject(pageId, request, true);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/reject/")
    public Response reject(@PathParam(value="pageId") long pageId, ApprovalRequest request) {
        return this.approveOrReject(pageId, request, false);
    }

    @ViewWorkflowPermissionRequired
    private Response approveOrReject(long pageId, final ApprovalRequest request, final boolean approve) {
        return new AbstractRestResources.WorkflowCommand(){

            @Override
            protected Response doInCommand(AbstractPage page) throws WorkflowException {
                if (approve) {
                    ApprovalResources.this.approvalService.approve((ContentEntityObject)page, request.getName(), request.getUser(), request.getPassword(), request.getNote());
                } else {
                    ApprovalResources.this.approvalService.reject((ContentEntityObject)page, request.getName(), request.getUser(), request.getPassword(), request.getNote());
                }
                return ApprovalResources.this.getStatus(page, false);
            }
        }.execute(pageId);
    }

    @ViewWorkflowPermissionRequired
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/assign/")
    public Response assign(@PathParam(value="pageId") long pageId, final ApprovalRequest request) {
        class AssignCommand
        extends AbstractRestResources.WorkflowCommand {
            AssignCommand() {
                super(ApprovalResources.this);
            }

            @Override
            public Response doInCommand(AbstractPage page) throws WorkflowException {
                for (Assignee assignee : request.getAssignees()) {
                    ApprovalResources.this.approvalService.assign((ContentEntityObject)page, request.getName(), assignee, request.getNote());
                }
                return ApprovalResources.this.getStatus(page, false);
            }
        }
        return new AssignCommand().execute(pageId);
    }

    @ViewWorkflowPermissionRequired
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/unassign/")
    public Response unassign(@PathParam(value="pageId") long pageId, final ApprovalRequest request) {
        class AssignCommand
        extends AbstractRestResources.WorkflowCommand {
            AssignCommand() {
                super(ApprovalResources.this);
            }

            @Override
            public Response doInCommand(AbstractPage page) throws WorkflowException {
                for (Assignee assignee : request.getAssignees()) {
                    ApprovalResources.this.approvalService.unassign((ContentEntityObject)page, request.getName(), assignee.username, request.getNote());
                }
                return ApprovalResources.this.getStatus(page, false);
            }
        }
        return new AssignCommand().execute(pageId);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{spaceKey}/roles/")
    public Response replaceApprovalRoles(@PathParam(value="spaceKey") String spaceKey, String jsonApprovalRoles) {
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The Space key parameter is mandatory.").build();
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("The provided Space key: " + spaceKey + " does not match to any existing Space")).build();
        }
        if (StringUtils.isNotBlank((CharSequence)jsonApprovalRoles) && !JsonSerialiserUtil.isJSONValid(jsonApprovalRoles)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The provided JSON is not valid").build();
        }
        if (!this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)AuthenticatedUserThreadLocal.get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Space admin privileges are required to perform this operation.").build();
        }
        this.approvalRolesManager.replaceApprovalRoles(spaceKey, jsonApprovalRoles);
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/roles/")
    public Response getApprovalRoles(@PathParam(value="spaceKey") String spaceKey) {
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"The Space key parameter is mandatory.").build();
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (space == null || !this.spacePermissionManager.hasPermission("VIEWSPACE", space, (User)user)) {
            return Response.status((int)404).build();
        }
        boolean canViewWorkflows = this.workflowPermissionManager.canViewWorkflows(space, user);
        if (!canViewWorkflows) {
            return Response.status((int)403).build();
        }
        String jsonValue = this.approvalRolesManager.retrieveApprovalRoles(spaceKey);
        return Response.ok().entity((Object)jsonValue).type("application/json").build();
    }

    @Override
    protected boolean canEditAndCreate(Space space) {
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption(() -> this.spacePermissionManager.hasPermission("EDITSPACE", space, (User)AuthenticatedUserThreadLocal.get()));
    }
}

