/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.action.condition;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class ConfluenceBuildNumberCondition
implements Condition {
    protected static final String MIN_PARAM = "minBuildNumber";
    protected static final String MAX_PARAM = "maxBuildNumber";
    private int min;
    private int max;
    private final BootstrapManager bootstrapManager;

    public ConfluenceBuildNumberCondition(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public boolean shouldDisplay(Map<String, Object> arg0) {
        int buildNumber = 0;
        try {
            buildNumber = Integer.parseInt(this.bootstrapManager.getBuildNumber());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.min <= buildNumber && buildNumber < this.max;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        this.min = MapUtils.getIntValue(params, MIN_PARAM, -1);
        this.max = MapUtils.getIntValue(params, MAX_PARAM, Integer.MAX_VALUE);
    }
}

