/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

jQuery.fn.extend({
    initPageWorkflowParameters : function() {
        jQuery("#pageparameters").find(".assignment").each(function() {
            jQuery(this).initAssignment();
        });
        jQuery("#editParameters").click(function() {
            jQuery("#pageparameters").addClass("editing");
            jQuery("#pageparameters .assignment").each(function() {
                jQuery(this).enableAssignment();
            });
        });
        jQuery("#closeParameters").click(function() {
            jQuery("a.aprv-tab.pageparameters").click();
        });
        jQuery("#cancelParameters").click(function() {
            jQuery(this).submitPageParameters("viewPageParameters");
        });
        jQuery("#saveParameters").click(function() {
            jQuery(this).submitPageParameters("savePageParameters");
        });
        setTimeout(function() {
            jQuery(".workflowError").hide();
        },2000);
    },

    submitPageParameters : function(action) {
        var uri = getActionPath() + action + ".action";
        var params = {pageId : getPageId()};
        jQuery("#pageparameters input.paramValue").each(function() {
            var name = jQuery(this).attr("name");
            params[name] = jQuery(this).val();
        });
        jQuery("#pageparameters input[name='users']").each(function() {
            var id = jQuery(this).attr("id").substring(0);
            var name = id.substring(0,id.indexOf("-users"));
            params[name] = jQuery(this).val();
        });
        jQuery("#pageparameters select").each(function() {
            var name = jQuery(this).attr("name");
            params[name] = jQuery(this).find("option:selected").val();
        });
        jQuery("#tab-tabpageparameters").load(uri,params,function() {
            jQuery(this).initPageWorkflowParameters();
            jQuery(".watchedvalues").each(function() {
                var name = jQuery(this).attr("id");
                var value = jQuery(this).html();
                jQuery("." + name).fadeOut(function() {
                    jQuery(this).html(value).show();
                });
            })
        });
        return false;
    }
});

function initWorkflowParameters() {
    jQuery(this).initPageWorkflowParameters();
}
