/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AWP = AWP || {};
AWP.View = AWP.View || {};

AWP.View.WorkflowTemplateOption = Backbone.View.extend({
    tagName: "option",
    model: AWP.Model.WorkflowTemplate,

    render: function() {
        this.$el.attr("value",this.model.get("id"));
        this.$el.html(this.model.get("name"));
        return this;
    }
});

AWP.View.SelectWorkflowTab = Backbone.View.extend({
    model: AWP.Model.Workflow,

    id : "select-workflow",
    icon: "workflow",
    caption: "Add Workflow",
    className: "tabs-pane",
    template: AWP.Templates.workflowSelection,

    events: {
        "click .add-workflow" : "addWorkflow",
        "click .cancel" : "cancel",
        "change select" : "select"
    },

    select: function() {
        var id = AJS.$("#select-workflow-templates option:selected").attr("value");
        if (id == 0) {
            this.$adhocSection.removeClass("hidden");
        } else {
            this.$adhocSection.addClass("hidden");
        }
    },

    addWorkflow: function(event) {
        event.preventDefault();
        var id = AJS.$("#select-workflow-templates option:selected").attr("value");
        var selected = this.model.get("templates").get(id);
        selected.save({},{stateNames: this.$stateNames.val()});
    },

    cancel: function(event) {
        event.preventDefault();
        AWP.View.WorkflowApp.closeDialog();
    },

    render: function() {
        this.$el.append(this.template({
            model : this.model
        }));

        this.$adhocSection = this.$(".adhocstates");
        this.$stateNames = this.$(".state-names");

        if(!_.isUndefined(this.model.get("templates"))) {
                this.model.get("templates").each(function(workflowTemplate) {
                var view = new AWP.View.WorkflowTemplateOption({
                    model: workflowTemplate,
                    value: workflowTemplate.get("id")
                });
                this.$("#select-workflow-templates").append(view.render().el);
            },this);

            // let's add an 'empty' workflow template into the templates collection.
            this.model.get("templates").add(new AWP.Model.WorkflowTemplate({id: 0}));
        }
        else {
            // no available templates, lets add the option to create a blank workflow anyways
            this.model.set({
                templates: new AWP.Collection.WorkflowTemplates({id: 0})
            });

            this.$adhocSection.removeClass("hidden");
        }

        this.$("#select-workflow-templates").append(AWP.Templates.adhocTemplateOption());
        
        return this;
    }
});

AWP.View.IntroTab = Backbone.View.extend({
    id : "intro",
    icon : "workflow",
    caption: "Comala Workflows",
    template: AWP.Templates.intro,
    
    events: {
        'click .openTaskTab' : 'openTaskTab',
        'click .addApproval' : 'addApproval',
        'click .addWorkflow' : 'addWorkflow',
        'click .cancelAddApproval' : 'render'
    },
    
    render: function() {
        var addApproval = true;

        // If Add (default) Approval is not avaialable, then
        // do not display the 'add approval' option at the welcome screen
        if(window.parent.jQuery('#addApprovalWorkflow').length == 0) {
            addApproval = false;
        }

        this.$el.append(this.template({
            tasks: this.model.isShowTasks(),
            spaceAdmin: this.model.get("isSpaceAdmin"),
            spaceWorkflowURL: AWP.contextPath + "/spaces/viewspaceworkflows.action?key="+ this.model.get("spaceKey"),
            addApproval: addApproval
        }));
        return this;
    },
    
    addApproval: function (evt) {
        evt.preventDefault();
        // other slides
        var slide = new AWP.View.SimpleApprovalSlide({
            // slide prop
            hidden: true,
            caption: 'Add Approval',
            header: false
        });
        
        slide.render();
        slide.show();
        
        return false;
    },
    
    openTaskTab: function (evt) {
        evt.preventDefault();
        AJS.$('.menu-item.tasks a').click();
    },
    
    addWorkflow: function (evt) {
        evt.preventDefault();
        
        // other slides
        var slide = new AWP.View.selectWorkflowSlide({
            // slide prop
            model: this.model,
            footer: true,
            hidden: true,
            caption: 'Add Workflow'
        });
        
        slide.render();
        slide.show();
    }
});
