/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class IOUtils {
    private IOUtils() {
    }

    public static int pipe(InputStream in, OutputStream out) throws IOException {
        int size;
        byte[] buff = new byte[1024];
        int count = 0;
        while ((size = in.read(buff)) != -1) {
            out.write(buff, 0, size);
            count += size;
        }
        return count;
    }

    public static int pipe(Reader in, Writer out) throws IOException {
        int size;
        char[] buff = new char[1024];
        int count = 0;
        while ((size = in.read(buff)) != -1) {
            out.write(buff, 0, size);
            count += size;
        }
        return count;
    }

    public static int copy(File from, File to) throws FileNotFoundException, IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(from));
        if (!to.exists()) {
            File parent = to.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            to.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(to);
        int transferred = IOUtils.pipe(in, out);
        in.close();
        out.close();
        return transferred;
    }
}

