/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.adhocworkflows.rest.AbstractAdhocResources;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflowsRepository;
import com.comalatech.confluence.workflowcontainer.rest.RemoteRepositoryRestModel;
import com.comalatech.workflow.WorkflowHandler;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@WorkflowsAppRequired
@Path(value="/remote")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RemoteRepositoryResources
extends AbstractAdhocResources {
    protected final WorkflowContainerManager workflowContainerManager;

    public RemoteRepositoryResources(PageManager pageManager, PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, AccessModeService accessModeService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowHandler workflowHandler, UserSearchManager userSearchManager, BootstrapManager bootstrapManager, WorkflowContainerManager workflowContainerManager) {
        super(pageManager, permissionManager, workflowPermissionManager, spaceManager, spacePermissionManager, accessModeService, workflowsFeatureManager, workflowConfigurationManager, workflowHandler, userSearchManager, bootstrapManager);
        this.workflowContainerManager = workflowContainerManager;
    }

    @GET
    @Path(value="/workflows")
    @TypeHint(value=RemoteRepositoryRestModel.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Remote resources")})
    public Response getRemoteWorkflows() {
        RemoteWorkflowsRepository remoteWorkflows = this.workflowContainerManager.getRemoteWorkflows(false);
        return Response.ok((Object)RemoteRepositoryRestModel.buildFrom(this.workflowContainerManager, remoteWorkflows)).build();
    }
}

