/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.label.LabelEvent;
import com.comalatech.confluence.states.event.StateTransitionEvent;
import com.comalatech.confluence.states.event.TaskEvent;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.events.InternalApprovalEvent;
import com.comalatech.confluence.workflow.events.WorkflowCustomEvent;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.TriggerEvents;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import com.comalatech.confluence.workflowcontainer.model.Macroable;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import com.comalatech.workflow.event.WorkflowPageParameterUpdatedEvent;
import com.opensymphony.util.TextUtils;
import java.util.List;

public class Trigger
extends WorkflowElement
implements Macroable {
    String action;
    ConfluenceEvent event;
    Class[] triggeringEvents;
    int version;
    boolean queue;
    String eventName;
    String newEvent;
    private boolean explicit;
    private String description;

    public Trigger(ConfluenceEvent event, boolean explicit, String eventName, List<Condition> conditions, String action, boolean queue, String newEvent, String description) {
        super(conditions);
        this.event = event;
        this.eventName = eventName;
        this.action = action;
        this.queue = queue;
        this.newEvent = newEvent;
        this.explicit = explicit;
        this.description = description;
        this.triggeringEvents = TriggerEvents.getTriggerEvents(event);
    }

    public String getDescription() {
        return this.description;
    }

    public Class[] getTriggeringEvents() {
        return this.triggeringEvents;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getAction() {
        return this.action;
    }

    public String getAction(ConfluenceEvent event) {
        return this.action;
    }

    public String getTrimmedAction(ConfluenceEvent event) {
        return this.getAction(event).replaceAll("\n\\p{Blank}*", "\n").trim();
    }

    public boolean isQueue() {
        return this.queue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName());
        sb.append(" ").append(TriggerEvents.eventToString(this.event)).append("->");
        for (Condition condition : this.conditions) {
            sb.append(condition.toString()).append("|");
        }
        return sb.toString();
    }

    public ConfluenceEvent getEvent() {
        return this.event;
    }

    public String getNewEvent() {
        return this.newEvent;
    }

    public void validate() throws WorkflowException {
        if (this.event instanceof PageCreateEvent && (this.action.indexOf("addlabel") >= 0 || this.action.indexOf("removelabel") >= 0)) {
            throw new WorkflowException("adding/removing labels when creating pages is not supported at this time");
        }
    }

    public String getFormatedAction() {
        return this.fixIndentation(this.action.trim());
    }

    private String fixIndentation(String str) {
        String[] lines = str.trim().split("\r\n|\r|\n");
        if (lines.length == 1) {
            return str.trim();
        }
        int minSpaces = Integer.MAX_VALUE;
        for (int i = 1; i < lines.length; ++i) {
            char[] chars = lines[i].toCharArray();
            if (chars.length <= 0) continue;
            int spaces = 0;
            for (int j = 0; j < chars.length && chars[j] == ' '; ++j) {
                ++spaces;
            }
            if (spaces >= minSpaces) continue;
            minSpaces = spaces;
        }
        if (minSpaces < Integer.MAX_VALUE) {
            StringBuffer extraIndent = new StringBuffer();
            for (int i = 0; i < minSpaces; ++i) {
                extraIndent.append(' ');
            }
            String indent = extraIndent.toString();
            StringBuffer sb = new StringBuffer();
            if (lines[0].trim().length() > 0) {
                sb.append(lines[0]);
                sb.append("\n");
            }
            boolean first = true;
            for (int i = 1; i < lines.length; ++i) {
                String line = lines[i];
                if (lines[i].indexOf(indent) == 0) {
                    sb.append(line.substring(minSpaces)).append("\n");
                } else if (!first || line.trim().length() > 0) {
                    sb.append(line).append("\n");
                }
                first = false;
            }
            return sb.toString().trim();
        }
        return str.trim();
    }

    public String getEventDescriptionWiki() {
        StringBuffer wiki = new StringBuffer(TriggerEvents.eventToString(this.event));
        if (this.queue) {
            wiki.append(" (action will be queued)");
        }
        return wiki.toString();
    }

    @Override
    public SerializableMacro toMacro() {
        SerializableMacro macro = new SerializableMacro("trigger", true);
        macro.addParameter(this.eventName);
        this.appendEventParameters(macro);
        for (Condition condition : this.conditions) {
            condition.addMacroParameters(macro);
        }
        if (this.queue) {
            macro.addParameter("queue", (Object)this.queue);
        }
        if (TextUtils.stringSet((String)this.newEvent)) {
            macro.addParameter("newevent", (Object)this.newEvent);
        }
        macro.setBody(this.action.trim());
        return macro;
    }

    private void appendEventParameters(SerializableMacro macro) {
        WorkflowPageParameterUpdatedEvent paramEvent;
        if (this.event instanceof InternalApprovalEvent) {
            InternalApprovalEvent approvalEvent = (InternalApprovalEvent)this.event;
            macro.addParameter("approval", (Object)approvalEvent.getApprovalName());
            if (approvalEvent.isPartial()) {
                macro.addParameter("partial", (Object)true);
            }
        } else if (this.event instanceof LabelEvent) {
            LabelEvent labelEvent = (LabelEvent)this.event;
            if (labelEvent.getLabel().getName() != null) {
                macro.addParameter("label", (Object)labelEvent.getLabel());
            }
        } else if (this.event instanceof StateTransitionEvent) {
            StateTransitionEvent stateTransitionEvent = (StateTransitionEvent)this.event;
            macro.addParameter("state", (Object)stateTransitionEvent.getState().getState());
        } else if (this.event instanceof WorkflowCustomEvent) {
            WorkflowCustomEvent workflowCustomEvent = (WorkflowCustomEvent)this.event;
            macro.addParameter("success", (Object)workflowCustomEvent.isSuccess());
        } else if (this.event instanceof TaskEvent) {
            TaskEvent taskEvent = (TaskEvent)this.event;
            if (taskEvent.getTask() != null) {
                macro.addParameter("task", (Object)taskEvent.getTask().getName());
            }
        } else if (this.event instanceof WorkflowPageParameterUpdatedEvent && (paramEvent = (WorkflowPageParameterUpdatedEvent)this.event).getWorkflowParameter() != null && paramEvent.getWorkflowParameter().getName() != null) {
            macro.addParameter("parameter", (Object)paramEvent.getWorkflowParameter().getName());
        }
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isExplicit() {
        return this.explicit;
    }
}

