/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions.k15.scrollpdfexporter;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginState;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.events.PdfExportErrorEvent;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.model.PdfExportActionModel;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.model.PdfTemplateExportIntegrationModel;
import com.comalatech.confluence.pdfexport.k15t.scrollpdfexporter.service.DefaultPdfTemplateExportIntegrationService;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.util.RenderUtils;
import com.comalatech.confluence.workflow.activeobjects.accessor.QueuedJobEntityAccessor;
import com.comalatech.confluence.workflow.macros.actions.AbstractActionMacro;
import com.comalatech.confluence.workflow.stats.TrackedPluginsEnum;
import com.comalatech.confluence.workflow.tasks.manager.QueuedJobManager;
import com.comalatech.workflow.model.State;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfExportMacro
extends AbstractActionMacro {
    private static final Logger log = LoggerFactory.getLogger(PdfExportMacro.class);
    public static final String MACRO_NAME = "pdf-export";
    public static final String TEMPLATE_KEY = "template";
    private QueuedJobManager queuedJobManager;
    private PluginAccessor pluginAccessor;
    private DefaultPdfTemplateExportIntegrationService defaultPdfTemplateExportIntegrationService;
    private EventPublisher eventPublisher;
    private StateAccessor stateAccessor;

    public String execute(Map macroParams, String s, RenderContext renderContext) throws MacroException {
        if (!this.inExecuteMode(renderContext)) {
            return "";
        }
        AbstractPage page = this.getPageFrom(renderContext);
        PageState pageState = this.stateAccessor.getLatestState(page);
        if (this.isPdfExportAvailable(page, renderContext)) {
            try {
                String templateId = this.getTemplateId(macroParams, renderContext, page);
                this.queuedJobManager.addToQueue(QueuedJobEntityAccessor.JobType.PDF_EXPORT_ACTION, new PdfExportActionModel(page.getId(), AuthenticatedUserThreadLocal.getUsername(), templateId));
            }
            catch (Exception ex) {
                log.error("Error while adding pdf job to the queue", (Throwable)ex);
                this.logMessage(renderContext, "There has been an error adding the pdf generation action to the queue for page: " + page.getId());
                this.eventPublisher.publish((Object)new PdfExportErrorEvent((Object)this, page, (State)pageState, ex));
            }
        } else {
            String k15tNotFoundMessage = ConfluenceActionSupport.getTextStatic((String)"com.comalatech.macro.k15t.error.pdf-export-plugin-not-found");
            this.setUserMessage(renderContext, k15tNotFoundMessage);
            this.eventPublisher.publish((Object)new PdfExportErrorEvent((Object)this, page, (State)pageState, k15tNotFoundMessage));
        }
        return "";
    }

    private AbstractPage getPageFrom(RenderContext renderContext) throws MacroException {
        AbstractPage abstractPage = this.getAbstractPage(renderContext);
        if (abstractPage == null) {
            String errorMsg = ConfluenceActionSupport.getTextStatic((String)"com.comalatech.macro.k15t.error.pdf-export-page-not-found");
            this.setUserMessage(renderContext, errorMsg);
            this.eventPublisher.publish((Object)new PdfExportErrorEvent((Object)this, null, null, errorMsg));
            throw new MacroException("Pdf-export action macro failed. The page associated to the macro could not be found in the context");
        }
        return abstractPage;
    }

    private boolean isPdfExportAvailable(AbstractPage page, RenderContext renderContext) {
        Plugin k15tPlugin = this.pluginAccessor.getPlugin(TrackedPluginsEnum.SCROLL_PDF.getKey());
        return k15tPlugin != null && k15tPlugin.getPluginState().equals((Object)PluginState.ENABLED);
    }

    private String getTemplateId(Map macroParams, RenderContext renderContext, AbstractPage page) {
        String templateId = null;
        String userTypedTemplate = (String)macroParams.get(TEMPLATE_KEY);
        try {
            templateId = this.defaultPdfTemplateExportIntegrationService.getTemplateId(userTypedTemplate, page.getSpaceKey());
        }
        catch (IOException e) {
            log.error("Error while retrieving template id for: {0}. Error message: {1}", (Object)userTypedTemplate, (Object)e.getMessage());
            this.setUserMessage(renderContext, ConfluenceActionSupport.getTextStatic((String)"com.comalatech.macro.k15t.error.pdf-export-template-not-retrieved", (Object[])new String[]{String.valueOf(page.getId())}));
        }
        if (!this.isTemplateAvailable(templateId, userTypedTemplate)) {
            this.setUserMessage(renderContext, ConfluenceActionSupport.getTextStatic((String)"com.comalatech.macro.k15t.error.pdf-export-template-not-found", (Object[])new String[]{RenderUtils.javaScriptBlock(userTypedTemplate)}));
        }
        return templateId;
    }

    private boolean isTemplateAvailable(String templateId, String userTypedTemplate) {
        PdfTemplateExportIntegrationModel pdfTemplateExportIntegrationModel = new PdfTemplateExportIntegrationModel(templateId, userTypedTemplate);
        return pdfTemplateExportIntegrationModel.isTemplateAvailable(templateId, userTypedTemplate);
    }

    private void logMessage(RenderContext renderContext, String message) {
        renderContext.addParam((Object)"com.comalatech.log", (Object)message);
    }

    private void setUserMessage(RenderContext renderContext, String message) {
        renderContext.addParam((Object)"com.comalatech.user.message", (Object)RenderUtils.javaScriptBlock(message));
    }

    public void setQueuedJobManager(QueuedJobManager queuedJobManager) {
        this.queuedJobManager = queuedJobManager;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setDefaultPdfTemplateExportIntegrationService(DefaultPdfTemplateExportIntegrationService defaultPdfTemplateExportIntegrationService) {
        this.defaultPdfTemplateExportIntegrationService = defaultPdfTemplateExportIntegrationService;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setStateAccessor(StateAccessor stateAccessor) {
        this.stateAccessor = stateAccessor;
    }

    @Override
    protected String getName() {
        return MACRO_NAME;
    }
}

