/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners.triggers.tasks;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.manager.EventHistoryManager;
import com.comalatech.confluence.states.event.AllBlogPostTasksCompleteEvent;
import com.comalatech.confluence.states.event.AllPageTasksCompleteEvent;
import com.comalatech.confluence.states.event.AllTasksCompleteEvent;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.listeners.StateHandler;
import com.comalatech.confluence.workflow.listeners.triggers.TriggersListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllTasksTriggersListener
extends TriggersListener {
    private static final Logger log = LoggerFactory.getLogger(AllTasksTriggersListener.class);
    private final StateHandler stateHandler;

    public AllTasksTriggersListener(WorkflowAccessor workflowAccessor, WorkflowActionManager workflowActionManager, EventPublisher eventPublisher, StateHandler stateHandler, EventHistoryManager eventHistoryManager, DarkFeatureManager darkFeatureManager) {
        super(workflowAccessor, workflowActionManager, eventHistoryManager, darkFeatureManager, eventPublisher);
        this.stateHandler = stateHandler;
    }

    @EventListener
    public void onAllBlogPostTasksCompleteEvent(AllBlogPostTasksCompleteEvent event) {
        this.handleEventTrigger((ConfluenceEvent)event);
    }

    @EventListener
    public void onAllPageTasksCompleteEvent(AllPageTasksCompleteEvent event) {
        this.handleEventTrigger((ConfluenceEvent)event);
    }

    @Override
    public void handleEventTrigger(ConfluenceEvent event) {
        try {
            this.logEventSource(event);
            this.processHistoryEvent(event);
            PageWorkflows pageWorkflows = this.getPageWorkflows(event);
            if (pageWorkflows == null) {
                return;
            }
            this.stateHandler.handle((AllTasksCompleteEvent)event, pageWorkflows);
            this.evaluateTriggers(pageWorkflows, event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }
}

