/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners.triggers.state;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.documentActivity.manager.EventHistoryManager;
import com.comalatech.confluence.metadata.atlassian.AtlassianMetadataHandler;
import com.comalatech.confluence.states.event.BlogPostStateTransitionEvent;
import com.comalatech.confluence.states.event.PageStateTransitionEvent;
import com.comalatech.confluence.states.event.StateTransitionEvent;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.listeners.StateHandler;
import com.comalatech.confluence.workflow.listeners.triggers.TriggersListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateTransitionTriggersListener
extends TriggersListener {
    private static final Logger log = LoggerFactory.getLogger(StateTransitionTriggersListener.class);
    private final StateHandler stateHandler;
    private final AtlassianMetadataHandler atlassianMetadataHandler;

    public StateTransitionTriggersListener(WorkflowAccessor workflowAccessor, WorkflowActionManager workflowActionManager, EventPublisher eventPublisher, StateHandler stateHandler, AtlassianMetadataHandler atlassianMetadataHandler, EventHistoryManager eventHistoryManager, DarkFeatureManager darkFeatureManager) {
        super(workflowAccessor, workflowActionManager, eventHistoryManager, darkFeatureManager, eventPublisher);
        this.stateHandler = stateHandler;
        this.atlassianMetadataHandler = atlassianMetadataHandler;
    }

    @EventListener
    public void onBlogPostStateTransitionEvent(BlogPostStateTransitionEvent event) {
        this.handleEventTrigger((ConfluenceEvent)event);
    }

    @EventListener
    public void onPageStateTransitionEvent(PageStateTransitionEvent event) {
        this.handleEventTrigger((ConfluenceEvent)event);
    }

    @Override
    public void handleEventTrigger(ConfluenceEvent event) {
        try {
            this.logEventSource(event);
            this.processHistoryEvent(event);
            PageWorkflows pageWorkflows = this.getPageWorkflows(event);
            if (pageWorkflows == null) {
                return;
            }
            if (this.atlassianMetadataHandler.updateProperties((AbstractPage)((StateTransitionEvent)event).getContent(), pageWorkflows)) {
                try {
                    pageWorkflows = this.workflowAccessor.getWorkflows(pageWorkflows.getPage(), event);
                }
                catch (WorkflowException e) {
                    if (log.isDebugEnabled()) {
                        log.error("", (Throwable)e);
                    }
                    log.error(e.getMessage());
                }
            }
            this.stateHandler.handle((StateTransitionEvent)event, pageWorkflows);
            this.evaluateTriggers(pageWorkflows, event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }
}

