/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.compatibility;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.VersionHistorySummary;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.ArrayList;
import java.util.List;

public class PageContributorsHelper {
    private BootstrapManager bootstrapManager;
    private PageManager pageManager;

    public PageContributorsHelper(PageManager pageManager, BootstrapManager bootstrapManager) {
        this.pageManager = pageManager;
        this.bootstrapManager = bootstrapManager;
    }

    public List<ConfluenceUser> getPageContributors(VersionHistorySummary historySummary) {
        if (!this.isConfluence60()) {
            return null;
        }
        List contributors = historySummary.getContributors();
        return contributors;
    }

    public List<ConfluenceUser> getPageContributors(long pageId) {
        if (!this.isConfluence60()) {
            return null;
        }
        AbstractPage abstractPage = this.pageManager.getAbstractPage(pageId);
        List versionHistorySummaries = this.pageManager.getVersionHistorySummaries((ContentEntityObject)abstractPage);
        if (versionHistorySummaries != null && versionHistorySummaries.size() > 0) {
            VersionHistorySummary lastVersion = (VersionHistorySummary)versionHistorySummaries.get(0);
            List contributors = lastVersion.getContributors();
            return contributors;
        }
        return null;
    }

    public List<String> getPageContributorsUsernames(long pageId) {
        List<ConfluenceUser> pageContributors = this.getPageContributors(pageId);
        ArrayList<String> contributorNames = new ArrayList<String>();
        for (ConfluenceUser confluenceUser : pageContributors) {
            contributorNames.add(confluenceUser.getName());
        }
        return contributorNames;
    }

    private boolean isConfluence60() {
        try {
            int buildNumber = Integer.parseInt(this.bootstrapManager.getBuildNumber());
            return buildNumber >= 7101;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

