/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc.api;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.spaces.Space;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.template.LinkedTemplateManager;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkflowTemplateManager
implements WorkflowTemplateManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowTemplateManager.class);
    private final WorkflowContainerManager workflowContainerManager;
    private final LinkedTemplateManager linkedTemplateManager;

    public DefaultWorkflowTemplateManager(WorkflowContainerManager workflowContainerManager, LinkedTemplateManager linkedTemplateManager) {
        this.workflowContainerManager = workflowContainerManager;
        this.linkedTemplateManager = linkedTemplateManager;
    }

    @Override
    public List<com.comalatech.workflow.model.Workflow> getWorkflowTemplates() {
        return this.convertWorkflowList(this.workflowContainerManager.getAvailableWorkflowTemplates(null));
    }

    public List<com.comalatech.workflow.model.Workflow> getAllWorkflowTemplates() {
        return this.convertWorkflowList(this.workflowContainerManager.getWorkflowTemplates(null));
    }

    @Override
    public List<com.comalatech.workflow.model.Workflow> getWorkflowTemplates(Space space) {
        return this.convertWorkflowList(this.workflowContainerManager.getWorkflowTemplates(space));
    }

    @Override
    public void addWorkflowTemplate(Space space, String workflowMarkup) throws WorkflowException {
        Workflow workflow = this.workflowContainerManager.renderWorkflow(workflowMarkup);
        this.addWorkflowTemplate(space, workflow);
    }

    public void addWorkflowTemplate(Space space, Workflow workflow) throws WorkflowException {
        workflow.validateWorkflow();
        if (TextUtils.stringSet((String)workflow.getErrorMessage())) {
            throw new WorkflowUserException("comalatech.awp.designer.error.markup", workflow.getErrorMessage());
        }
        if (!TextUtils.stringSet((String)workflow.getName())) {
            throw new WorkflowUserException("comalatech.awp.designer.error.workflow.name.empty");
        }
        Workflow existingTemplate = this.workflowContainerManager.getWorkflowTemplate(space != null ? space.getKey() : null, workflow.getName());
        if (existingTemplate != null) {
            throw new WorkflowException(ConfluenceActionSupport.getTextStatic((String)"cw.spaceadmin.addWorkflowAlreadyExist"));
        }
        this.workflowContainerManager.saveWorkflowTemplate(space != null ? space.getKey() : null, workflow, false, null);
    }

    @Override
    public void removeWorkflowTemplate(Space space, String workflowName) {
        if (space == null) {
            this.removeGlobalWorkflowTemplate(workflowName);
        } else {
            this.workflowContainerManager.removeWorkflowTemplate(space.getKey(), workflowName);
        }
    }

    public void removeGlobalWorkflowTemplate(String workflowName) {
        this.workflowContainerManager.removeWorkflowTemplate(null, workflowName);
        List<String> linkedSpaceKeys = this.linkedTemplateManager.getLinkedSpaces(workflowName);
        for (String spaceKey : linkedSpaceKeys) {
            this.linkedTemplateManager.removeTemplateLink(spaceKey, workflowName);
        }
        List<String> linkedSpaceLabels = this.linkedTemplateManager.getLinkedSpaceLabels(workflowName);
        for (String spaceLabel : linkedSpaceLabels) {
            this.linkedTemplateManager.removeSpaceLabelLink(spaceLabel, workflowName);
        }
    }

    @Override
    public void activateGlobalTemplate(String workflowName) throws WorkflowException {
        this.toggleWorkflowActive(workflowName, true);
    }

    @Override
    public void deactivateGlobalTemplate(String workflowName) throws WorkflowException {
        this.toggleWorkflowActive(workflowName, false);
    }

    @Override
    public void copyGlobalTemplate(String workflowName) {
        Workflow workflow = null;
        try {
            workflow = this.workflowContainerManager.getWorkflowTemplate(null, workflowName);
        }
        catch (com.comalatech.confluence.workflow.WorkflowException e) {
            log.info("global workflow template not found: " + workflowName);
        }
        if (workflow != null) {
            this.workflowContainerManager.copyWorkflowTemplate(null, workflow);
        }
    }

    protected void toggleWorkflowActive(String workflowName, boolean active) throws WorkflowException {
        Workflow workflow = null;
        try {
            workflow = this.workflowContainerManager.getWorkflowTemplate(null, workflowName);
        }
        catch (com.comalatech.confluence.workflow.WorkflowException e) {
            log.info("global workflow template not found: " + workflowName);
        }
        if (workflow != null) {
            if (TextUtils.stringSet((String)workflow.getErrorMessage())) {
                throw new WorkflowException(workflow.getErrorMessage());
            }
            this.workflowContainerManager.setGlobalWorkflowActive(null, workflowName, active);
        }
    }

    protected List<com.comalatech.workflow.model.Workflow> convertWorkflowList(List<Workflow> list) {
        return new ArrayList<com.comalatech.workflow.model.Workflow>(list);
    }
}

