/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.rest.validator;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowVisibilityPermissionsRequired;
import com.comalatech.confluence.util.validators.PermissionValidator;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import java.lang.annotation.Annotation;
import java.util.Collection;

public class DefaultPermissionValidator
implements PermissionValidator {
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final AccessModeService accessModeService;
    private final PermissionManager permissionManager;
    private final PageManager pageManager;

    public DefaultPermissionValidator(WorkflowConfigurationManager workflowConfigurationManager, AccessModeService accessModeService, PermissionManager permissionManager, PageManager pageManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.accessModeService = accessModeService;
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
    }

    @Override
    public void validate(Collection<Annotation> annotations, Long pageId) throws ApplicationPermissionException {
        this.validateUserPermission(annotations, pageId);
    }

    @Override
    public void validate(Collection<Annotation> annotations) throws ApplicationPermissionException {
        this.validate(annotations, null);
    }

    private void validateUserPermission(Collection<Annotation> annotations, Long pageId) throws ApplicationPermissionException {
        ConfluenceUser user;
        if (annotations.stream().noneMatch(a -> a.annotationType().equals(WorkflowVisibilityPermissionsRequired.class))) {
            return;
        }
        AbstractPage target = null;
        if (pageId != null) {
            target = this.pageManager.getAbstractPage(pageId.longValue());
        }
        if ((user = AuthenticatedUserThreadLocal.get()) == null || target == null) {
            throw new ApplicationPermissionException("Forbidden: No user or target has been specified. Cannot perform validation.");
        }
        if (!this.hasEditPermissionOverrideSettingEnabled(target.getSpaceKey()) && !this.canEdit(user, target)) {
            throw new ApplicationPermissionException("Forbidden: The user has no edit permission on the page and the Workflows visibility configuration setting does not allow to override that restriction.");
        }
    }

    private boolean hasEditPermissionOverrideSettingEnabled(String spaceKey) {
        return WorkflowVisibilityInternal.ANY.equals((Object)this.workflowConfigurationManager.getHistoryVisibility(spaceKey));
    }

    private boolean canEdit(ConfluenceUser user, AbstractPage target) {
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption(() -> this.permissionManager.hasPermission((User)user, Permission.EDIT, (Object)target));
    }
}

