/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.service;

import com.comalatech.confluence.cloud.migration.accessor.WorkflowsUsageAccessor;
import com.comalatech.confluence.cloud.migration.accessor.model.WorkflowsUsageSpace;
import com.comalatech.confluence.cloud.migration.service.WorkflowsUsageReportService;
import com.comalatech.confluence.cloud.migration.service.model.WorkflowsUsageReport;
import com.comalatech.confluence.translator.application.ServerWorkflowCommand;
import com.comalatech.confluence.translator.domain.CloudTranslation;
import com.comalatech.confluence.translator.domain.WorkflowTranslator;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class DefaultWorkflowsUsageReportService
implements WorkflowsUsageReportService {
    private final WorkflowsUsageAccessor workflowsUsageAccessor;
    private final WorkflowService workflowService;
    private final WorkflowMarkupManager workflowMarkupManager;
    private final WorkflowTranslator workflowTranslator;

    public DefaultWorkflowsUsageReportService(WorkflowsUsageAccessor workflowsUsageAccessor, WorkflowService workflowService, WorkflowMarkupManager workflowMarkupManager, WorkflowTranslator workflowTranslator) {
        this.workflowsUsageAccessor = workflowsUsageAccessor;
        this.workflowService = workflowService;
        this.workflowMarkupManager = workflowMarkupManager;
        this.workflowTranslator = workflowTranslator;
    }

    @Override
    public List<WorkflowsUsageReport> getSpacesReport() {
        ArrayList<WorkflowsUsageReport> workflowsUsageReports = new ArrayList<WorkflowsUsageReport>();
        List<WorkflowsUsageSpace> spacesWithWorkflows = this.workflowsUsageAccessor.getWorkflowsUsageBySpaces();
        for (WorkflowsUsageSpace spaceData : spacesWithWorkflows) {
            List<com.comalatech.workflow.model.Workflow> workflowsInSpace = this.workflowService.getWorkflows(spaceData.getSpaceKey());
            if (workflowsInSpace.isEmpty()) continue;
            workflowsUsageReports.addAll(workflowsInSpace.stream().map(spaceWorkflow -> {
                Workflow workflow = (Workflow)spaceWorkflow;
                return WorkflowsUsageReport.builder().space(spaceData).workflow(workflow).type(this.parseWorkflowType(workflow.getType())).isCloudCompatible(this.validateCloudCompatibility(workflow)).build();
            }).collect(Collectors.toList()));
        }
        return workflowsUsageReports;
    }

    @Override
    public List<WorkflowsUsageReport> getPagesReport() {
        return null;
    }

    private boolean validateCloudCompatibility(Workflow workflow) {
        String jsonWorkflowString = this.workflowMarkupManager.convertToJson(workflow);
        CloudTranslation cloudTranslation = this.workflowTranslator.handle(ServerWorkflowCommand.builder().workflow(new JSONObject(jsonWorkflowString).toMap()).build());
        return Objects.isNull(cloudTranslation.getMessages()) || cloudTranslation.getMessages().isEmpty();
    }

    private String parseWorkflowType(Workflow.WorkflowType workflowType) {
        switch (workflowType) {
            case PAGE: {
                return "page";
            }
            case SPACE: {
                return "space";
            }
            case LINKED_SPACE: {
                return "global";
            }
        }
        return workflowType.toString();
    }
}

