/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.accessor;

import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.comalatech.confluence.cloud.migration.accessor.WorkflowsUsageAccessor;
import com.comalatech.confluence.cloud.migration.accessor.model.WorkflowsUsageSpace;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;

public class DefaultWorkflowsUsageAccessor
implements WorkflowsUsageAccessor {
    private final EntityManagerProvider entityManagerProvider;
    private static final String SQL_WORKFLOWS_USAGE_PER_SPACE = "select space.name as SPACE_NAME, space.key as SPACE_KEY from BucketPropertySetItem propertySet, ContentEntityObject content, Space space where propertySet.entityId = content.id and space.id = content.space.id and propertySet.key = 'com.comalatech.states' group by  space.name, space.key";

    public DefaultWorkflowsUsageAccessor(EntityManagerProvider entityManagerProvider) {
        this.entityManagerProvider = entityManagerProvider;
    }

    @Override
    public List<WorkflowsUsageSpace> getWorkflowsUsageBySpaces() {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery(SQL_WORKFLOWS_USAGE_PER_SPACE, Tuple.class);
        List workflowActivityItems = query.getResultList();
        return workflowActivityItems.stream().map(record -> new WorkflowsUsageSpace((String)record.get("SPACE_NAME"), (String)record.get("SPACE_KEY"))).collect(Collectors.toList());
    }
}

