/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var Adhoc = Adhoc || {};
Adhoc.Workflow = Adhoc.Workflow || {};

Adhoc.viewHistory = false;

/**
 * @deprecated Anything new goes to AWP.*
 */
(function ($) {

    Adhoc.clickedApprovalId = null;
    Adhoc.dialog = null;
    Adhoc.dialogOptions = {
            width: 280,
            offsetY: 17,
            offsetX: -40,
            hideDelay: 10000
    };
    Adhoc.activityOptions = {
            onHover: true,
            width: 380,
            offsetY: 10,
            offsetX: -40,
            hideDelay: 500
    };

    Adhoc.setPresetUsers = function($dropdown, users) {
        $dropdown.empty();
        for (var i = 0; i < users.length;i++) {
            $dropdown.append(AJS.template.load("adhocworkflows-user").fill(users[i]));
        }
        $dropdown.find("a").click(Adhoc.clickAssignee);
    };

    Adhoc.updateAssignButton = function ($assignees) {
        var button = $assignees.parents("form").find("input.assign");
        if ($assignees.find("li").length > 0) {
            button.removeAttr("disabled");
        } else {
            button.attr("disabled", "disabled");

        }
    };
    Adhoc.addAssignee = function($assignees, name, fullName, pictureUrl, assigneeClass) {
        if ($assignees.find("li[name='" + name + "']").length > 0) {
            return;
        }
        if ($assignees.hasClass("single")) {
            $assignees.find("li").remove();
        }
        var user = {
            name: name,
            fullName: fullName,
            pictureUrl: pictureUrl
        };
        $assignees.append(AJS.template.load("adhocworkflows-assignee").fill(user));
        var $assignee = $assignees.find("li[name='" + user.name + "']");
        if (assigneeClass !== undefined) {
            $assignee.addClass(assigneeClass);
        }
        $assignee.find(".remove-assignee").click(Adhoc.removeAssignee);
        Adhoc.updateAssignButton($assignees);
    };

    Adhoc.removeAssignee = function () {
        var $assignees = $(this).parents("ol");
        var $assignee = $(this).parents("li");
        $assignee.remove();
        Adhoc.updateAssignButton($assignees);
        return false;
    };

    // when clicked as presetUser
    Adhoc.clickAssignee = function() {
        var $form = $(this).parents("form");
        var name = $(this).attr("name");
        var $assignees = $form.find("ol.assignees.select");
        $.ajax({
            type: "GET",
            cache: false,
            url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/workflow/userdetails?username=" + name,
            success: function (response, textStatus, jqXHR) {
                if (response !== undefined) {
                    var user = response;
                    Adhoc.addAssignee($assignees,user.name,user.fullName,user.pictureUrl);
                }
            },
            error: function() {}
        });
        AJS.dropDown.current.hide();
        return false;
    };

    // when selected through autocompleteUser
    Adhoc.selectAssignee = function(e, selected) {
        try {
            var $form = $(this).parents("form");
            var $assignees = $form.find("ol.assignees.select");
            var user = selected.content;
            Adhoc.addAssignee($assignees,user.username,user.title,user.thumbnailLink.href);
            $form.find("input.autocomplete-user").val("");
        } catch (err) {
        }
        return false;
    };

    Adhoc.getAssignees = function($form) {
        var $assignees = $form.find("ol.assignees.select li, ol.assignees.assignee li");
        var separator = "";
        var assignees = "";
        $assignees.each(function () {
            assignees = assignees + separator + jQuery(this).attr("name");
            separator = ",";
        });
        return assignees;
    };

    Adhoc.errorHandler = function(data, status) {
        console.error("Error, check Adhoc.errorData and Adhoc.errorStatus");
        Adhoc.errorData = data;
        Adhoc.errorStatus = status;
    };

    Adhoc.doHidePopup = function() {
        Adhoc.dialog.hide();
        return false;
    };

    Adhoc.generateActionDialog = function($contents, action) {
        Adhoc.action = action;
        $contents.empty();
        if (action.hasParameters) {
            $contents.addClass("parameters");
        }
        if (action.showParameters) {
            Adhoc.Form.doFormDialog(action,$contents);
        } else if (action.approvals) {
            Adhoc.Approvals.doDialog(action,$contents);
        } else if (action.states) {
            Adhoc.Workflow.doStateDialog(action,$contents);
        } else {
            $("#adhocWorkflowsLink").addClass("published").unbind('click').click(function() {
                return false;
            });
            Adhoc.doHidePopup();
        }
        $contents.find("a.parameters").click(Adhoc.Form.showParameters);
    };

    Adhoc.getUrlParams = function getUrlParameters() {
        var map = {};
        var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m,key,value) {
            map[key] = value;
        });
        return map;
    };

    Adhoc.submitProgress = function($contents) {
        $contents.find("input, select, a").attr("disabled","disabled");
        var progressSpinner = Raphael.spinner($contents.find(".progress-messages-icon")[0], 7, "#666");
    };

    var generatePopup = function($contents, trigger, doShowPopup) {
        $contents.addClass("adhoc");
        $contents.empty();
        $contents.append(AJS.template.load("adhocworkflows-loading").fill());
        doShowPopup();
        var progressSpinner = Raphael.spinner($contents.find(".progress-messages-icon")[0], 7, "#666");

        var workflowButton = $("#adhocWorkflowsLink");
        if (workflowButton.hasClass("workflow-state")) {
            // Workflow action
            $.ajax({
                type: "GET",
                cache: false,
                url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/workflow/" +
                        AJS.params.pageId + "/actions" + (AJS.params.workflowAdmin ? "?admin=true" : ""),
                success: function (action, textStatus, jqXHR) {
                    Adhoc.generateActionDialog($contents,action);
                },
                error: Adhoc.errorHandler
            });
        } else if (workflowButton.hasClass("approvalworkflow")) {
            Adhoc.Workflow.doAddApprovalWorkflow();
        } else {
            // Template Selection
            $.ajax({
                type: "GET",
                cache: false,
                url: AJS.Confluence.getContextPath() + "/rest/adhocworkflows/latest/workflow/" + AJS.params.pageId + "/templates",
                success: function (response, textStatus, jqXHR) {
                    Adhoc.Workflow.doTemplatesDialog(response,$contents,jqXHR);
                },
                error: Adhoc.errorHandler
            });
        }
    };

    AJS.toInit(function ($) {

        $("#labelsString").focus(Adhoc.Workflow.refreshState); // to refresh when a label workflow is added
        if (AJS.params.publishedView) {
            $("#adhocWorkflowsLink").addClass("published").click(function() {return false;});
            $('body').addClass('cw-published-view');
        } else if (AJS.params.anonymous) {
            $("#adhocWorkflowsLink").click(function() {return false;});
        } else {
            Adhoc.dialog = AJS.InlineDialog($("#adhocWorkflowsLink"), "adhocWorkflowsPopup", generatePopup, Adhoc.dialogOptions);
        }
        if ($("#workflow-page-status").length === 0) {
            return;
        }

        var pageState = {
            stateName: AJS.params.stateName,
            stateDescription: AJS.params.stateDescription,
            finalState: AJS.params.finalState,
            hasFinalState: AJS.params.hasFinalState,
            publishedView: AJS.params.publishedView,
            alternateViewStateName: AJS.params.alternateViewStateName,
            alternateViewUrl: AJS.params.alternateViewUrl,
            taskable: AJS.params.taskable,
            hoverDescription: AJS.params.hoverDescription
        };

        var $content;
        // global look and feel theme
        if($("#main-content").length) {
            $content = $("#main-content");
        }
        // documentation theme
        else if($("#content > .wiki-content").length) {
            $content = $("#content > .wiki-content");
        }
        // Move Messages/headers/footers into correct locations above and below the main content div.
        if($content) {
            $content.before("<div id='workflow-page-message'></div>");
            if($("workflow-license-message")){
                $content.before($("#workflow-license-message"));
            }
            if($("#workflow-page-header")) {
                $content.before($("#workflow-page-header"));
            }
            if($("#workflow-page-footer")) {
                $content.after($("#workflow-page-footer"));
            }
        }


        Adhoc.publishedView = pageState.publishedView;
        if (Adhoc.publishedView) {
            $("#viewPageLink").hide();
            $("#viewPageLink").parents("li").hide();
        } else {
            if (pageState.alternateViewUrl) { // If alternate view link is being shown, decorate export links
                var pdfLink = $("#action-export-pdf-link").attr("href");
                $("#action-export-pdf-link").attr("href", pdfLink + '&publishedView=false');
                var wordLink = $("#action-export-word-link").attr("href");
                $("#action-export-word-link").attr("href", wordLink + '&publishedView=false');
            }
        }
    });

})(AJS.$);
