/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.AbstractUserCondition;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import java.util.Arrays;

public class ExcludeCondition
extends AbstractUserCondition {
    public ExcludeCondition(String userList) {
        super(true, userList);
        this.allowInApprovalsOrLite = false;
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        String[] usersToCheck = this.getUsersListResolver().getValueAsUserNames(valueStore, valueStore.getPage(), String.join((CharSequence)",", this.userNames), false);
        ConfluenceUser authUser = this.getUser();
        for (String userToCheck : usersToCheck) {
            String user = userToCheck.trim();
            if (!(user == null ? authUser == null : authUser != null && authUser.getName().equals(user))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        macro.addParameter("exclude", (Object)MiscUtils.stringListToCommaSeparatedList(this.getUserNames(), ","));
    }

    @Override
    public String toString(ValueStore valueStore) {
        return "exclude user " + this.makeNiceUsersList(valueStore);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExcludeCondition)) {
            return false;
        }
        ExcludeCondition c = (ExcludeCondition)o;
        return Arrays.equals(this.getUserNames(), c.getUserNames());
    }
}

