/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Entity;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.AbstractUserGroupApproverCondition;
import com.comalatech.confluence.workflow.model.Selector;
import com.comalatech.confluence.workflow.model.ValueReference;
import java.util.Collection;

public abstract class AbstractUserCondition
extends AbstractUserGroupApproverCondition {
    public static final String ANONYMOUS_USER = "anonymous";
    public String[] userNames;

    public AbstractUserCondition(boolean not, String userList) {
        super(not);
        this.userNames = AbstractUserCondition.makeValues(userList);
        for (int i = 0; i < this.userNames.length; ++i) {
            if (!this.userNames[i].equalsIgnoreCase(ANONYMOUS_USER)) continue;
            this.userNames[i] = null;
        }
    }

    protected String makeNiceUsersList(ValueStore valueStore) {
        StringBuffer list = new StringBuffer();
        for (int i = 0; i < this.userNames.length; ++i) {
            String userName = this.userNames[i];
            if (i > 0) {
                if (i == this.userNames.length - 1) {
                    list.append(" or ");
                } else {
                    list.append(", ");
                }
            }
            if (userName == null) {
                list.append(ANONYMOUS_USER);
                continue;
            }
            list.append(ValueReference.referenceToString(userName, valueStore));
        }
        return list.toString();
    }

    public String[] getUserNames() {
        return this.userNames;
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public Collection<Entity> getSelectableUsersOrGroups(ValueStore valueStore, Selector selector) throws WorkflowException {
        return this.getUsersListResolver().getValueAsUsersOrGroups(valueStore, String.join((CharSequence)",", this.userNames));
    }

    @Override
    public ConfluenceUser[] getSelectableUsers(ValueStore valueStore, Selector selector, boolean ignoreExceptions) throws WorkflowException {
        return this.getUsersListResolver().getValueAsUsers(valueStore, valueStore.getPage(), String.join((CharSequence)",", this.userNames), ignoreExceptions);
    }

    @Override
    public String[] getRequiredUsersOrGroups(ValueStore valueStore, Selector selector) throws WorkflowException {
        return new String[0];
    }
}

