/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.comalatech.confluence.ipc.api.ApprovalCompletion;
import com.comalatech.confluence.ipc.api.PartialApprovalCompletion;
import com.comalatech.confluence.ipc.api.PartialRejectionCompletion;
import com.comalatech.confluence.ipc.api.RejectionCompletion;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.compatibility.AttachmentIdHelper;
import com.comalatech.confluence.workflow.dao.ApprovalCheckDao;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.workflow.event.approval.ApprovalApprovedEvent;
import com.comalatech.workflow.event.approval.ApprovalRejectedEvent;
import com.comalatech.workflow.model.Rejection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApprovalAccessor
implements ApprovalAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultApprovalAccessor.class);
    private final ApprovalCheckDao approvalCheckDao;
    private final WorkflowAccessor workflowAccessor;
    private final AttachmentManager attachmentManager;
    private final AttachmentIdHelper attachmentIdHelper;

    public DefaultApprovalAccessor(ApprovalCheckDao approvalCheckDao, WorkflowAccessor workflowAccessor, AttachmentManager attachmentManager, AttachmentIdHelper attachmentIdHelper) {
        this.approvalCheckDao = approvalCheckDao;
        this.workflowAccessor = workflowAccessor;
        this.attachmentManager = attachmentManager;
        this.attachmentIdHelper = attachmentIdHelper;
    }

    @Override
    public ApprovalCheck[] getApprovalChecks(AbstractPage page) {
        ApprovalCheck[] approvalChecks = this.approvalCheckDao.getApprovalChecks(page);
        return this.confluence57AttachmentIDFix(page, approvalChecks);
    }

    @Override
    public void saveApprovalChecks(AbstractPage page, ApprovalCheck[] approvals) {
        this.approvalCheckDao.saveApprovalChecks(page, approvals);
    }

    private ApprovalCheck[] confluence57AttachmentIDFix(AbstractPage page, ApprovalCheck[] approvalChecks) {
        if (approvalChecks != null && approvalChecks.length > 0 && !this.approvalCheckDao.isAttachmentIDsMigrated(page)) {
            log.info("Checking for changed Attachment Ids for page: " + page);
            Map<Long, Long> oldNewIdMap = this.attachmentIdHelper.getOldNewAttachmentIds(page.getId());
            if (oldNewIdMap.size() > 0) {
                log.info("Found changed Attachment Ids, fixing workflow history. " + oldNewIdMap);
                for (ApprovalCheck approvalCheck : approvalChecks) {
                    List<ApprovalCheck.CheckedAttachment> checkedAttachments = Arrays.asList(approvalCheck.getAttachments());
                    for (ApprovalCheck.CheckedAttachment checkedAttachment : checkedAttachments) {
                        if (!oldNewIdMap.containsKey(checkedAttachment.id)) continue;
                        checkedAttachment.id = oldNewIdMap.get(checkedAttachment.id);
                    }
                    approvalCheck.setCheckedAttachments(checkedAttachments);
                }
                this.saveApprovalChecks(page, approvalChecks);
            }
            this.approvalCheckDao.setAttachmentIDsMigrated(page);
        }
        return approvalChecks;
    }

    @Override
    public Integer getFinalApprovalCheckId(AbstractPage page) {
        return this.approvalCheckDao.getFinalApprovalCheckId(page);
    }

    @Override
    public void setFinalApprovalCheckId(AbstractPage page, int approvalCheckId) {
        this.approvalCheckDao.setFinalApprovalCheckId(page, approvalCheckId);
    }

    @Override
    public void clearFinalApprovalId(AbstractPage page) {
        this.approvalCheckDao.clearFinalApprovalId(page);
    }

    @Override
    public ApprovalCheck getFinalApprovalCheck(AbstractPage page, String approvalName, int approvalId) {
        AbstractPage latestVersion = page.getLatestVersion();
        if (approvalId > 0) {
            return this.getApprovalCheck(latestVersion, approvalId);
        }
        if (approvalName != null) {
            ApprovalCheck check = this.getLatestApprovalCheck(latestVersion, null, approvalName, 0);
            if (check == null || !check.isApproved()) {
                return null;
            }
            return check;
        }
        return null;
    }

    @Override
    public ApprovalCheck getFinalApprovalCheck(AbstractPage page) {
        try {
            Integer id = this.getFinalApprovalCheckId(page);
            if (id != null) {
                return this.getFinalApprovalCheck(page, null, id);
            }
        }
        catch (NumberFormatException e) {
            log.error("Invalid approval id on " + page, (Throwable)e);
        }
        return null;
    }

    @Override
    public ApprovalCheck getApprovalCheck(AbstractPage page, int approvalId) {
        ApprovalCheck[] checks = this.getApprovalChecks(page);
        if (approvalId > checks.length || approvalId <= 0) {
            Integer id = this.getFinalApprovalCheckId(page);
            if (id != null && id == approvalId) {
                log.error("Invalid approval id " + approvalId + ": there are only " + checks.length + " checks in " + page + ". Removing finalApprovalId");
                this.clearFinalApprovalId(page);
            } else {
                log.error("Invalid approval id " + approvalId + ": there are only " + checks.length + " checks in " + page);
            }
            return null;
        }
        return checks[approvalId - 1];
    }

    private ApprovalCheck getLastApprovalCheckWithPredicate(List<ApprovalCheck> checks, Predicate<ApprovalCheck> predicate) {
        Comparator<ApprovalCheck> sorter = Comparator.comparingInt(entry -> entry.getId());
        return checks.stream().sorted(sorter.reversed()).filter(predicate).findFirst().orElse(null);
    }

    private ApprovalCheck getLatestApprovedApprovalCheck(AbstractPage page, PageState pageState, String approvalName) {
        List<ApprovalCheck> checks = this.getApprovalChecks(page, pageState);
        return this.getLastApprovalCheckWithPredicate(checks, check -> check.getName().equals(approvalName) && check.isApproved());
    }

    @Override
    public ApprovalCheck getLatestApprovalCheck(AbstractPage page, PageState pageState, String approvalName, int version) {
        page = page.getLatestVersion();
        List<ApprovalCheck> checks = this.getApprovalChecks(page, pageState);
        return this.getLastApprovalCheckWithPredicate(checks, check -> check.getName().equals(approvalName) && (version == 0 || version >= check.getVersion()));
    }

    @Override
    public ApprovalCheck getApprovalCheck(ValueStore valueStore, String approvalName, boolean current, boolean checkEvents) {
        AbstractPage page = valueStore.getPage();
        ConfluenceEvent event = valueStore.getEvent();
        if (current) {
            PageState pageState = valueStore.getPageState();
            int version = page.getVersion();
            if (event instanceof ApprovalRejectedEvent) {
                String eventApprovalName = ((ApprovalRejectedEvent)event).getApprovalName();
                if (eventApprovalName.equals(approvalName)) {
                    ApprovalCheck check = this.getLatestApprovedApprovalCheck(page, pageState, approvalName);
                    if (check != null && check.getVersion() == version) {
                        return check;
                    }
                    return null;
                }
            } else if (event instanceof PageUpdateEvent || event instanceof BlogPostUpdateEvent) {
                --version;
            }
            return this.getLatestApprovalCheck(page, pageState, approvalName, version);
        }
        if (checkEvents) {
            if (event instanceof ApprovalRejectedEvent) {
                ApprovalCheck check = this.getLatestApprovedApprovalCheck(page, null, approvalName);
                if (check != null && page.getVersion() == 1) {
                    return null;
                }
                return check;
            }
            if (event instanceof ApprovalApprovedEvent && ((ApprovalApprovedEvent)event).getApprovalName().equals(approvalName)) {
                return this.getPrecedingToLatestApprovalCheck(page, approvalName);
            }
        }
        return this.getLatestApprovalCheck(page, null, approvalName, 0);
    }

    private ApprovalCheck getPrecedingToLatestApprovalCheck(AbstractPage page, String approvalName) {
        List<ApprovalCheck> checks = this.getApprovalChecks(page, null);
        boolean[] first = new boolean[]{true};
        return this.getLastApprovalCheckWithPredicate(checks, check -> {
            if (check.getName().equals(approvalName) && check.isApproved()) {
                if (!first[0]) {
                    return true;
                }
                first[0] = false;
            }
            return false;
        });
    }

    @Override
    public void addInvolvedUsers(Set<String> userNames, AbstractPage page) {
        ApprovalCheck[] approvalChecks;
        for (ApprovalCheck check : approvalChecks = this.getApprovalChecks(page)) {
            for (com.comalatech.workflow.model.Approval approval : check.getApprovals()) {
                userNames.add(approval.getPerformer());
            }
            Collections.addAll(userNames, check.getRequiredApprovers());
        }
    }

    @Override
    public int getFinalApprovedPageVersionAndSetFinalApprovalCheck(AbstractPage page, HttpServletRequest request) throws IllegalArgumentException, IllegalStateException {
        if (!page.isLatestVersion()) {
            throw new IllegalArgumentException(page.toString() + " is not latest version");
        }
        ApprovalCheck finalCheck = this.getFinalApprovalCheck(page);
        if (finalCheck == null) {
            throw new IllegalStateException("Final approval check version requested but none exists in page with id: " + page.getIdAsString());
        }
        request.setAttribute("approvalId", (Object)Integer.toString(finalCheck.getId()));
        return finalCheck.getVersion();
    }

    @Override
    public ApprovalCheck getLatestApprovalCheck(AbstractPage page) {
        ApprovalCheck[] approvalChecks = this.approvalCheckDao.getLatestApprovalChecks(page = page.getLatestVersion());
        if (approvalChecks == null) {
            approvalChecks = this.getApprovalChecks(page);
        }
        if (approvalChecks == null || approvalChecks.length == 0) {
            return null;
        }
        return approvalChecks[approvalChecks.length - 1];
    }

    @Override
    public List<ApprovalCheck> getLatestApprovalChecks(AbstractPage page, PageState pageState) {
        return this.getLatestChecks(this.getApprovalChecks(page, pageState));
    }

    @Override
    public List<ApprovalCheck> getLatestApprovalChecksForAnyState(AbstractPage page) {
        return this.getLatestChecks(Arrays.asList(this.getApprovalChecks(page)));
    }

    @Override
    public List<ApprovalCheck> getOldApprovalChecks(AbstractPage oldPage, PageState pageState) {
        return this.getLatestChecksWithVersion(this.getApprovalChecks(oldPage.getLatestVersion(), pageState), oldPage.getVersion());
    }

    private List<ApprovalCheck> getLatestChecks(List<ApprovalCheck> checks) {
        return this.getLatestChecksWithVersion(checks, null);
    }

    private List<ApprovalCheck> getLatestChecksWithVersion(List<ApprovalCheck> checks, Integer version) {
        HashSet approvalNames = new HashSet();
        Comparator<ApprovalCheck> sorter = Comparator.comparingInt(entry -> entry.getId());
        return checks.stream().sorted(sorter.reversed()).filter(check -> {
            if (!(approvalNames.contains(check.getName()) || version != null && check.getVersion() != version.intValue())) {
                approvalNames.add(check.getName());
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    private boolean hasAllRequiredChecks(AbstractPage page, PageState pageState, List<Approval> requiredApprovals, ApprovalCheck[] checks, boolean approve) {
        if (requiredApprovals.size() == 0) {
            return false;
        }
        HashSet<String> required = this.makeRequiredSet(requiredApprovals);
        for (int i = checks.length - 1; i >= 0; --i) {
            ApprovalCheck check = checks[i];
            if (pageState != null && check.getStateId() != pageState.getId() || !required.contains(check.getName()) || !check.isCheckUpToDate(page, pageState, true, this.attachmentManager)) continue;
            if (approve ? !check.isApproved() : !check.isRejected(true)) {
                return false;
            }
            required.remove(check.getName());
            if (required.size() != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAllRequiredChecks(AbstractPage page, PageState pageState, List<Approval> requiredApprovals, boolean approve) {
        ApprovalCheck[] checks = this.getApprovalChecks(page);
        return this.hasAllRequiredChecks(page, pageState, requiredApprovals, checks, approve);
    }

    private HashSet<String> makeRequiredSet(List<Approval> requiredApprovals) {
        HashSet<String> set = new HashSet<String>(requiredApprovals.size());
        for (Approval approval : requiredApprovals) {
            set.add(approval.getName());
        }
        return set;
    }

    @Override
    public List<ApprovalCheck> getApprovalChecks(AbstractPage page, PageState pageState) {
        ApprovalCheck[] checks = this.approvalCheckDao.getLatestApprovalChecks(page);
        if (checks != null && checks.length > 0 && pageState != null && checks[0].getStateId() == pageState.getId()) {
            return Arrays.asList(checks);
        }
        checks = this.getApprovalChecks(page);
        if (pageState == null) {
            return Arrays.asList(checks);
        }
        return this.getApprovalChecksForState(checks, pageState.getId());
    }

    @Override
    public List<Approval> getUncompletedApprovals(AbstractPage page, PageState pageState) {
        ArrayList<Approval> uncompleted = new ArrayList<Approval>();
        try {
            PageWorkflows pageWorkflows = this.workflowAccessor.getWorkflows(page);
            if (pageWorkflows != null) {
                List<ApprovalCheck> approvalChecks = this.getApprovalChecks(page, pageState);
                for (Approval approval : pageWorkflows.getApprovals(pageState)) {
                    if (this.approvalCompleted(approval, approvalChecks, page, pageState)) continue;
                    uncompleted.add(approval);
                }
            }
        }
        catch (WorkflowException we) {
            we.printStackTrace();
        }
        return uncompleted;
    }

    private boolean approvalCompleted(Approval approval, List<ApprovalCheck> approvalChecks, AbstractPage page, PageState pageState) {
        for (ApprovalCheck approvalCheck : approvalChecks) {
            if (!approvalCheck.isCompleted() || !approvalCheck.getName().equals(approval.getName()) || !approvalCheck.isCheckUpToDate(page, pageState, true, this.attachmentManager)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ApprovalCheck> getAllApprovalChecksForState(ApprovalCheck[] checks, PageState pageState) {
        ArrayList<ApprovalCheck> filteredChecks = new ArrayList<ApprovalCheck>();
        boolean foundAny = false;
        for (int i = checks.length - 1; i >= 0; --i) {
            ApprovalCheck check = checks[i];
            if (check.getStateId() == pageState.getId()) {
                filteredChecks.add(0, check);
                foundAny = true;
                continue;
            }
            if (foundAny) break;
        }
        return filteredChecks;
    }

    private List<ApprovalCheck> getApprovalChecksForState(ApprovalCheck[] checks, int stateId) {
        ArrayList<ApprovalCheck> filteredChecks = new ArrayList<ApprovalCheck>();
        HashSet<String> checkNames = new HashSet<String>();
        for (int i = checks.length - 1; i >= 0; --i) {
            ApprovalCheck check = checks[i];
            if (check.getStateId() == stateId) {
                if (checkNames.contains(check.getName())) continue;
                filteredChecks.add(0, check);
                checkNames.add(check.getName());
                continue;
            }
            if (checkNames.size() > 0) break;
        }
        return filteredChecks;
    }

    @Override
    public void setApprovalsAndRejections(ApprovalCheck[] approvalChecks, PageState pageState) {
        if (pageState == null) {
            log.error("There is no page state to set the approvals and rejections to.");
            return;
        }
        ArrayList<com.comalatech.workflow.model.Approval> approvals = new ArrayList<com.comalatech.workflow.model.Approval>();
        ArrayList<Rejection> rejections = new ArrayList<Rejection>();
        for (ApprovalCheck approvalCheck : approvalChecks) {
            if (approvalCheck.getStateId() != pageState.getId()) continue;
            boolean partial = approvalCheck.isRejected(true) ? false : !approvalCheck.isApproved();
            for (com.comalatech.workflow.model.Approval approver : approvalCheck.getApprovals()) {
                if (approver.isApproved()) {
                    if (partial) {
                        approvals.add(new PartialApprovalCompletion(approvalCheck.getName(), approvalCheck.getId(), approver.getPerformer(), approver.getDate(), approver.getComment(), approver.getSignatureType()));
                        continue;
                    }
                    approvals.add(new ApprovalCompletion(approvalCheck.getName(), approvalCheck.getId(), approver.getPerformer(), approver.getDate(), approver.getComment(), approver.getSignatureType()));
                    continue;
                }
                if (partial) {
                    rejections.add(new PartialRejectionCompletion(approvalCheck.getName(), approvalCheck.getId(), approver.getPerformer(), approver.getDate(), approver.getComment(), approver.getSignatureType()));
                    continue;
                }
                rejections.add(new RejectionCompletion(approvalCheck.getName(), approvalCheck.getId(), approver.getPerformer(), approver.getDate(), approver.getComment(), approver.getSignatureType()));
            }
        }
        pageState.setApprovals(approvals);
        pageState.setRejections(rejections);
    }

    @Override
    public String getApproversNames(ApprovalCheck approvalCheck) {
        return this.getApproversList(approvalCheck, true);
    }

    @Override
    public String getRejectorsNames(ApprovalCheck approvalCheck) {
        return this.getApproversList(approvalCheck, false);
    }

    private String getApproversList(ApprovalCheck approvalCheck, boolean approved) {
        List<Approver> approvers = approvalCheck.getLatestApprovers(approved);
        return MiscUtils.listToCommaSeparatedList(approvers, new MiscUtils.Extractor(){

            @Override
            public String getKey(Object object) {
                return ((Approver)object).getUser();
            }
        });
    }

    @Override
    public void removeApprovalChecks(AbstractPage page) {
        this.approvalCheckDao.removeApprovalChecks(page);
        this.approvalCheckDao.clearFinalApprovalId(page);
        this.approvalCheckDao.removeLatestApprovalChecks(page);
        this.approvalCheckDao.clearFinalApprovalId(page);
    }
}

